/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.query;

import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperation;
import com.att.aft.dme2.hazelcast.map.impl.query.MapQueryEngine;
import com.att.aft.dme2.hazelcast.map.impl.query.QueryResult;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.query.Predicate;
import com.att.aft.dme2.hazelcast.spi.PartitionAwareOperation;
import com.att.aft.dme2.hazelcast.spi.ReadonlyOperation;
import com.att.aft.dme2.hazelcast.util.IterationType;
import java.io.IOException;

public class QueryPartitionOperation
extends MapOperation
implements PartitionAwareOperation,
ReadonlyOperation {
    private Predicate predicate;
    private QueryResult result;
    private IterationType iterationType;

    public QueryPartitionOperation() {
    }

    public QueryPartitionOperation(String mapName, Predicate predicate, IterationType iterationType) {
        super(mapName);
        this.predicate = predicate;
        this.iterationType = iterationType;
    }

    @Override
    public void run() {
        MapQueryEngine queryEngine = this.mapServiceContext.getMapQueryEngine(this.name);
        this.result = queryEngine.queryLocalPartition(this.name, this.predicate, this.getPartitionId(), this.iterationType);
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.predicate);
        out.writeByte(this.iterationType.getId());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.predicate = (Predicate)in.readObject();
        this.iterationType = IterationType.getById(in.readByte());
    }
}

