/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.query;

import com.att.aft.dme2.hazelcast.map.QueryResultSizeExceededException;
import com.att.aft.dme2.hazelcast.map.impl.MapDataSerializerHook;
import com.att.aft.dme2.hazelcast.map.impl.query.QueryResultRow;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.query.impl.QueryableEntry;
import com.att.aft.dme2.hazelcast.util.IterationType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class QueryResult
implements IdentifiedDataSerializable,
Iterable<QueryResultRow> {
    private final Collection<QueryResultRow> rows = new LinkedList<QueryResultRow>();
    private Collection<Integer> partitionIds;
    private transient long resultLimit;
    private transient long resultSize;
    private IterationType iterationType;

    public QueryResult() {
        this.resultLimit = Long.MAX_VALUE;
    }

    public QueryResult(IterationType iterationType, long resultLimit) {
        this.resultLimit = resultLimit;
        this.iterationType = iterationType;
    }

    IterationType getIterationType() {
        return this.iterationType;
    }

    @Override
    public Iterator<QueryResultRow> iterator() {
        return this.rows.iterator();
    }

    public int size() {
        return this.rows.size();
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    long getResultLimit() {
        return this.resultLimit;
    }

    public void addAllRows(Collection<QueryResultRow> r) {
        this.rows.addAll(r);
    }

    public void addRow(QueryResultRow row) {
        this.rows.add(row);
    }

    public void addAll(Collection<QueryableEntry> entries) {
        for (QueryableEntry entry : entries) {
            if (++this.resultSize > this.resultLimit) {
                throw new QueryResultSizeExceededException();
            }
            Data key = null;
            Data value = null;
            switch (this.iterationType) {
                case KEY: {
                    key = entry.getKeyData();
                    break;
                }
                case VALUE: {
                    value = entry.getValueData();
                    break;
                }
                case ENTRY: {
                    key = entry.getKeyData();
                    value = entry.getValueData();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown iterationtype:" + (Object)((Object)this.iterationType));
                }
            }
            this.rows.add(new QueryResultRow(key, value));
        }
    }

    public Collection<Integer> getPartitionIds() {
        return this.partitionIds;
    }

    public void setPartitionIds(Collection<Integer> partitionIds) {
        this.partitionIds = partitionIds;
    }

    public Collection<QueryResultRow> getRows() {
        return this.rows;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 10;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        int partitionSize = this.partitionIds == null ? 0 : this.partitionIds.size();
        out.writeInt(partitionSize);
        if (partitionSize > 0) {
            for (Integer partitionId : this.partitionIds) {
                out.writeInt(partitionId);
            }
        }
        out.writeByte(this.iterationType.getId());
        int resultSize = this.rows.size();
        out.writeInt(resultSize);
        if (resultSize > 0) {
            for (QueryResultRow row : this.rows) {
                row.writeData(out);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int partitionSize = in.readInt();
        if (partitionSize > 0) {
            this.partitionIds = new ArrayList<Integer>(partitionSize);
            for (int i = 0; i < partitionSize; ++i) {
                this.partitionIds.add(in.readInt());
            }
        }
        this.iterationType = IterationType.getById(in.readByte());
        int resultSize = in.readInt();
        if (resultSize > 0) {
            for (int i = 0; i < resultSize; ++i) {
                QueryResultRow row = new QueryResultRow();
                row.readData(in);
                this.rows.add(row);
            }
        }
    }
}

