/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.query;

import com.att.aft.dme2.hazelcast.util.IterationType;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SortedQueryResultSet
extends AbstractSet<Map.Entry> {
    private final List<Map.Entry> entries;
    private final IterationType iterationType;

    public SortedQueryResultSet() {
        this(null, null);
    }

    public SortedQueryResultSet(List<Map.Entry> entries, IterationType iterationType) {
        this.entries = entries;
        this.iterationType = iterationType;
    }

    @Override
    public Iterator iterator() {
        if (this.entries == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new SortedIterator();
    }

    @Override
    public int size() {
        if (this.entries == null) {
            return 0;
        }
        return this.entries.size();
    }

    private class SortedIterator
    implements Iterator {
        private final Iterator<Map.Entry> iterator;

        private SortedIterator() {
            this.iterator = SortedQueryResultSet.this.entries.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Map.Entry entry = this.iterator.next();
            switch (SortedQueryResultSet.this.iterationType) {
                case KEY: {
                    return entry.getKey();
                }
                case VALUE: {
                    return entry.getValue();
                }
                case ENTRY: {
                    return entry;
                }
            }
            throw new IllegalStateException("Unrecognized iterationType:" + (Object)((Object)SortedQueryResultSet.this.iterationType));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

