/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.record;

import com.att.aft.dme2.hazelcast.config.MapConfig;
import com.att.aft.dme2.hazelcast.map.impl.record.ObjectRecord;
import com.att.aft.dme2.hazelcast.map.impl.record.ObjectRecordWithStats;
import com.att.aft.dme2.hazelcast.map.impl.record.Record;
import com.att.aft.dme2.hazelcast.map.impl.record.RecordFactory;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;

public class ObjectRecordFactory
implements RecordFactory<Object> {
    private final SerializationService serializationService;
    private final boolean statisticsEnabled;

    public ObjectRecordFactory(MapConfig config, SerializationService serializationService) {
        this.serializationService = serializationService;
        this.statisticsEnabled = config.isStatisticsEnabled();
    }

    @Override
    public Record<Object> newRecord(Object value) {
        assert (value != null) : "value can not be null";
        Object objectValue = this.serializationService.toObject(value);
        return this.statisticsEnabled ? new ObjectRecordWithStats(objectValue) : new ObjectRecord(objectValue);
    }

    @Override
    public void setValue(Record<Object> record, Object value) {
        assert (value != null) : "value can not be null";
        Object v = value;
        if (value instanceof Data) {
            v = this.serializationService.toObject(value);
        }
        record.setValue(v);
    }

    @Override
    public boolean isEquals(Object value1, Object value2) {
        Object v2;
        Object v1 = value1 instanceof Data ? this.serializationService.toObject(value1) : value1;
        Object object = v2 = value2 instanceof Data ? this.serializationService.toObject(value2) : value2;
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null) {
            return false;
        }
        if (v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }
}

