/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.recordstore;

import com.att.aft.dme2.hazelcast.concurrent.lock.LockService;
import com.att.aft.dme2.hazelcast.concurrent.lock.LockStore;
import com.att.aft.dme2.hazelcast.config.InMemoryFormat;
import com.att.aft.dme2.hazelcast.config.MapConfig;
import com.att.aft.dme2.hazelcast.map.impl.ExpirationTimeSetter;
import com.att.aft.dme2.hazelcast.map.impl.MapContainer;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.SizeEstimator;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.MapDataStore;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.MapStoreContext;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.MapStoreManager;
import com.att.aft.dme2.hazelcast.map.impl.record.Record;
import com.att.aft.dme2.hazelcast.map.impl.record.RecordFactory;
import com.att.aft.dme2.hazelcast.map.impl.record.Records;
import com.att.aft.dme2.hazelcast.map.impl.recordstore.BasicRecordStoreLoader;
import com.att.aft.dme2.hazelcast.map.impl.recordstore.RecordStore;
import com.att.aft.dme2.hazelcast.map.impl.recordstore.RecordStoreLoader;
import com.att.aft.dme2.hazelcast.map.impl.recordstore.Storage;
import com.att.aft.dme2.hazelcast.map.impl.recordstore.StorageImpl;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.query.impl.Indexes;
import com.att.aft.dme2.hazelcast.query.impl.QueryableEntry;
import com.att.aft.dme2.hazelcast.spi.DefaultObjectNamespace;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;
import com.att.aft.dme2.hazelcast.util.Clock;
import java.util.Collection;

abstract class AbstractRecordStore
implements RecordStore<Record> {
    protected final String name;
    protected final LockStore lockStore;
    protected final RecordFactory recordFactory;
    protected final MapContainer mapContainer;
    protected final MapServiceContext mapServiceContext;
    protected final SerializationService serializationService;
    protected final MapDataStore<Data, Object> mapDataStore;
    protected final MapStoreContext mapStoreContext;
    protected final InMemoryFormat inMemoryFormat;
    protected final int partitionId;
    protected Storage<Data, Record> storage;
    private long hits;
    private long lastAccess;
    private long lastUpdate;

    protected AbstractRecordStore(MapContainer mapContainer, int partitionId) {
        this.mapContainer = mapContainer;
        this.partitionId = partitionId;
        this.mapServiceContext = mapContainer.getMapServiceContext();
        this.serializationService = this.mapServiceContext.getNodeEngine().getSerializationService();
        this.name = mapContainer.getName();
        this.recordFactory = mapContainer.getRecordFactoryConstructor().createNew(null);
        this.inMemoryFormat = mapContainer.getMapConfig().getInMemoryFormat();
        this.mapStoreContext = mapContainer.getMapStoreContext();
        MapStoreManager mapStoreManager = this.mapStoreContext.getMapStoreManager();
        this.mapDataStore = mapStoreManager.getMapDataStore(this.name, partitionId);
        this.lockStore = this.createLockStore();
    }

    @Override
    public void init() {
        this.storage = this.createStorage(this.recordFactory, this.inMemoryFormat);
    }

    @Override
    public Record createRecord(Object value, long ttlMillis, long now) {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        Record record = this.recordFactory.newRecord(value);
        record.setCreationTime(now);
        record.setLastUpdateTime(now);
        long ttlMillisFromConfig = ExpirationTimeSetter.calculateTTLMillis(mapConfig);
        long ttl = ExpirationTimeSetter.pickTTL(ttlMillis, ttlMillisFromConfig);
        record.setTtl(ttl);
        long maxIdleMillis = ExpirationTimeSetter.calculateMaxIdleMillis(mapConfig);
        ExpirationTimeSetter.setExpirationTime(record, maxIdleMillis);
        this.updateStatsOnPut(true, now);
        return record;
    }

    @Override
    public Storage createStorage(RecordFactory recordFactory, InMemoryFormat memoryFormat) {
        return new StorageImpl(recordFactory, memoryFormat, this.serializationService);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MapContainer getMapContainer() {
        return this.mapContainer;
    }

    @Override
    public long getHeapCost() {
        return this.storage.getSizeEstimator().getSize();
    }

    protected long getNow() {
        return Clock.currentTimeMillis();
    }

    protected void updateRecord(Data key, Record record, Object value, long now) {
        this.updateStatsOnPut(false, now);
        record.onUpdate(now);
        this.storage.updateRecordValue(key, record, value);
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    protected void saveIndex(Record record, Object oldValue) {
        Data dataKey = record.getKey();
        Indexes indexes = this.mapContainer.getIndexes();
        if (indexes.hasIndex()) {
            Object value = Records.getValueOrCachedValue(record, this.serializationService);
            if (InMemoryFormat.NATIVE == this.inMemoryFormat) {
                dataKey = (Data)this.copyToHeap(dataKey);
                value = this.copyToHeap(value);
                oldValue = this.copyToHeap(oldValue);
            }
            QueryableEntry queryableEntry = this.mapContainer.newQueryEntry(dataKey, value);
            indexes.saveEntryIndex(queryableEntry, oldValue);
        }
    }

    protected void removeIndex(Record record) {
        Indexes indexes = this.mapContainer.getIndexes();
        if (indexes.hasIndex()) {
            Data key = record.getKey();
            Object value = Records.getValueOrCachedValue(record, this.serializationService);
            if (InMemoryFormat.NATIVE == this.inMemoryFormat) {
                key = (Data)this.copyToHeap(key);
                value = this.copyToHeap(value);
            }
            indexes.removeEntryIndex(key, value);
        }
    }

    protected Object copyToHeap(Object value) {
        return value instanceof Data ? this.toData(value) : value;
    }

    protected void removeIndex(Collection<Record> records) {
        Indexes indexes = this.mapContainer.getIndexes();
        if (!indexes.hasIndex()) {
            return;
        }
        for (Record record : records) {
            this.removeIndex(record);
        }
    }

    protected LockStore createLockStore() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService == null) {
            return null;
        }
        return lockService.createLockStore(this.partitionId, new DefaultObjectNamespace("hz:impl:mapService", this.name));
    }

    @Override
    public int getLockedEntryCount() {
        return this.lockStore.getLockedEntryCount();
    }

    protected RecordStoreLoader createRecordStoreLoader(MapStoreContext mapStoreContext) {
        return mapStoreContext.getMapStoreWrapper() == null ? RecordStoreLoader.EMPTY_LOADER : new BasicRecordStoreLoader(this);
    }

    protected Data toData(Object value) {
        return this.mapServiceContext.toData(value);
    }

    public void setSizeEstimator(SizeEstimator sizeEstimator) {
        this.storage.setSizeEstimator(sizeEstimator);
    }

    @Override
    public void disposeDeferredBlocks() {
        this.storage.disposeDeferredBlocks();
    }

    @Override
    public Storage<Data, ? extends Record> getStorage() {
        return this.storage;
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccess;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdate;
    }

    @Override
    public void increaseHits() {
        ++this.hits;
    }

    @Override
    public void increaseHits(long hits) {
        this.hits += hits;
    }

    @Override
    public void decreaseHits(long hits) {
        this.hits -= hits;
    }

    @Override
    public void setLastAccessTime(long time) {
        this.lastAccess = Math.max(this.lastAccess, time);
    }

    @Override
    public void setLastUpdateTime(long time) {
        this.lastUpdate = Math.max(this.lastUpdate, time);
    }

    protected void updateStatsOnPut(boolean newRecord, long now) {
        this.setLastUpdateTime(now);
        if (!newRecord) {
            this.updateStatsOnGet(now);
        }
    }

    protected void updateStatsOnPut(long hits) {
        this.increaseHits(hits);
    }

    protected void updateStatsOnGet(long now) {
        this.setLastAccessTime(now);
        this.increaseHits();
    }

    protected void updateStatsOnRemove(long hits) {
        this.decreaseHits(hits);
    }

    protected void resetStats() {
        this.hits = 0L;
        this.lastAccess = 0L;
        this.lastUpdate = 0L;
    }
}

