/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.tx;

import com.att.aft.dme2.hazelcast.cache.impl.nearcache.NearCache;
import com.att.aft.dme2.hazelcast.core.PartitioningStrategy;
import com.att.aft.dme2.hazelcast.map.impl.MapContainer;
import com.att.aft.dme2.hazelcast.map.impl.MapService;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperation;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperationProvider;
import com.att.aft.dme2.hazelcast.map.impl.record.RecordFactory;
import com.att.aft.dme2.hazelcast.map.impl.tx.MapTransactionLogRecord;
import com.att.aft.dme2.hazelcast.map.impl.tx.TxnUnlockOperation;
import com.att.aft.dme2.hazelcast.map.impl.tx.VersionedValue;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.InternalCompletableFuture;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.OperationFactory;
import com.att.aft.dme2.hazelcast.spi.TransactionalDistributedObject;
import com.att.aft.dme2.hazelcast.transaction.TransactionException;
import com.att.aft.dme2.hazelcast.transaction.TransactionNotActiveException;
import com.att.aft.dme2.hazelcast.transaction.TransactionOptions;
import com.att.aft.dme2.hazelcast.transaction.TransactionalObject;
import com.att.aft.dme2.hazelcast.transaction.impl.Transaction;
import com.att.aft.dme2.hazelcast.util.ExceptionUtil;
import com.att.aft.dme2.hazelcast.util.ThreadUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class TransactionalMapProxySupport
extends TransactionalDistributedObject<MapService>
implements TransactionalObject {
    protected final String name;
    protected final PartitioningStrategy partitionStrategy;
    protected final Map<Data, VersionedValue> valueMap = new HashMap<Data, VersionedValue>();
    protected final RecordFactory recordFactory;
    protected final MapOperationProvider operationProvider;
    protected final MapServiceContext mapServiceContext;

    public TransactionalMapProxySupport(String name, MapService mapService, NodeEngine nodeEngine, Transaction transaction) {
        super(nodeEngine, mapService, transaction);
        this.name = name;
        this.mapServiceContext = mapService.getMapServiceContext();
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(name);
        this.recordFactory = mapContainer.getRecordFactoryConstructor().createNew(null);
        this.operationProvider = this.mapServiceContext.getMapOperationProvider(name);
        this.partitionStrategy = mapContainer.getPartitioningStrategy();
    }

    protected boolean isEquals(Object value1, Object value2) {
        return this.recordFactory.isEquals(value1, value2);
    }

    protected void checkTransactionState() {
        if (!this.tx.getState().equals((Object)Transaction.State.ACTIVE)) {
            throw new TransactionNotActiveException("Transaction is not active!");
        }
    }

    public boolean containsKeyInternal(Data key) {
        MapOperation operation = this.operationProvider.createContainsKeyOperation(this.name, key);
        operation.setThreadId(ThreadUtil.getThreadId());
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        try {
            InternalCompletableFuture future = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            return (Boolean)future.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Object getInternal(Data key) {
        Object cached;
        MapService mapService = (MapService)this.getService();
        boolean nearCacheEnabled = mapService.getMapServiceContext().getMapContainer(this.name).hasMemberNearCache();
        if (nearCacheEnabled && (cached = mapService.getMapServiceContext().getNearCacheProvider().getFromNearCache(this.name, key)) != null) {
            if (cached.equals(NearCache.NULL_OBJECT)) {
                cached = null;
            }
            return cached;
        }
        MapOperation operation = this.operationProvider.createGetOperation(this.name, key);
        operation.setThreadId(ThreadUtil.getThreadId());
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        try {
            InternalCompletableFuture future = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            return future.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Object getForUpdateInternal(Data key) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis(), true);
        this.addUnlockTransactionRecord(key, versionedValue.version);
        return versionedValue.value;
    }

    public int sizeInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            OperationFactory sizeOperationFactory = this.operationProvider.createMapSizeOperationFactory(this.name);
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", sizeOperationFactory);
            int total = 0;
            for (Object result : results.values()) {
                Integer size = (Integer)this.getNodeEngine().toObject(result);
                total += size.intValue();
            }
            return total;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Data putInternal(Data key, Data value, long ttl, TimeUnit timeUnit) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        long timeInMillis = this.getTimeInMillis(ttl, timeUnit);
        MapOperation operation = this.operationProvider.createTxnSetOperation(this.name, key, value, versionedValue.version, timeInMillis);
        this.tx.add(new MapTransactionLogRecord(this.name, key, this.getPartitionId(key), operation, versionedValue.version, this.tx.getOwnerUuid()));
        return versionedValue.value;
    }

    public Data putIfAbsentInternal(Data key, Data value) {
        boolean unlockImmediately = !this.valueMap.containsKey(key);
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        if (versionedValue.value != null) {
            if (unlockImmediately) {
                this.unlock(key, versionedValue);
                return versionedValue.value;
            }
            this.addUnlockTransactionRecord(key, versionedValue.version);
            return versionedValue.value;
        }
        MapOperation operation = this.operationProvider.createTxnSetOperation(this.name, key, value, versionedValue.version, -1L);
        this.tx.add(new MapTransactionLogRecord(this.name, key, this.getPartitionId(key), operation, versionedValue.version, this.tx.getOwnerUuid()));
        return versionedValue.value;
    }

    public Data replaceInternal(Data key, Data value) {
        boolean unlockImmediately = !this.valueMap.containsKey(key);
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        if (versionedValue.value == null) {
            if (unlockImmediately) {
                this.unlock(key, versionedValue);
                return null;
            }
            this.addUnlockTransactionRecord(key, versionedValue.version);
            return null;
        }
        MapOperation operation = this.operationProvider.createTxnSetOperation(this.name, key, value, versionedValue.version, -1L);
        this.tx.add(new MapTransactionLogRecord(this.name, key, this.getPartitionId(key), operation, versionedValue.version, this.tx.getOwnerUuid()));
        return versionedValue.value;
    }

    public boolean replaceIfSameInternal(Data key, Object oldValue, Data newValue) {
        boolean unlockImmediately = !this.valueMap.containsKey(key);
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        if (!this.isEquals(oldValue, versionedValue.value)) {
            if (unlockImmediately) {
                this.unlock(key, versionedValue);
                return false;
            }
            this.addUnlockTransactionRecord(key, versionedValue.version);
            return false;
        }
        MapOperation operation = this.operationProvider.createTxnSetOperation(this.name, key, newValue, versionedValue.version, -1L);
        this.tx.add(new MapTransactionLogRecord(this.name, key, this.getPartitionId(key), operation, versionedValue.version, this.tx.getOwnerUuid()));
        return true;
    }

    public Data removeInternal(Data key) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        this.tx.add(new MapTransactionLogRecord(this.name, key, this.getPartitionId(key), this.operationProvider.createTxnDeleteOperation(this.name, key, versionedValue.version), versionedValue.version, this.tx.getOwnerUuid()));
        return versionedValue.value;
    }

    public boolean removeIfSameInternal(Data key, Object value) {
        boolean unlockImmediately = !this.valueMap.containsKey(key);
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        if (!this.isEquals(versionedValue.value, value)) {
            if (unlockImmediately) {
                this.unlock(key, versionedValue);
                return false;
            }
            this.addUnlockTransactionRecord(key, versionedValue.version);
            return false;
        }
        this.tx.add(new MapTransactionLogRecord(this.name, key, this.getPartitionId(key), this.operationProvider.createTxnDeleteOperation(this.name, key, versionedValue.version), versionedValue.version, this.tx.getOwnerUuid()));
        return true;
    }

    private void unlock(Data key, VersionedValue versionedValue) {
        try {
            NodeEngine nodeEngine = this.getNodeEngine();
            TxnUnlockOperation unlockOperation = new TxnUnlockOperation(this.name, key, versionedValue.version);
            unlockOperation.setThreadId(ThreadUtil.getThreadId());
            unlockOperation.setOwnerUuid(this.tx.getOwnerUuid());
            int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
            InternalCompletableFuture future = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", unlockOperation, partitionId);
            future.get();
            this.valueMap.remove(key);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private void addUnlockTransactionRecord(Data key, long version) {
        TxnUnlockOperation operation = new TxnUnlockOperation(this.name, key, version);
        this.tx.add(new MapTransactionLogRecord(this.name, key, this.getPartitionId(key), operation, version, this.tx.getOwnerUuid()));
    }

    private VersionedValue lockAndGet(Data key, long timeout) {
        return this.lockAndGet(key, timeout, false);
    }

    private VersionedValue lockAndGet(Data key, long timeout, boolean shouldLoad) {
        VersionedValue versionedValue = this.valueMap.get(key);
        if (versionedValue != null) {
            return versionedValue;
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        boolean blockReads = this.tx.getTransactionType() == TransactionOptions.TransactionType.ONE_PHASE;
        MapOperation operation = this.operationProvider.createTxnLockAndGetOperation(this.name, key, timeout, timeout, this.tx.getOwnerUuid(), shouldLoad, blockReads);
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
            InternalCompletableFuture future = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            versionedValue = (VersionedValue)future.get();
            if (versionedValue == null) {
                throw new TransactionException("Transaction couldn't obtain lock for the key: " + this.toObjectIfNeeded(key));
            }
            this.valueMap.put(key, versionedValue);
            return versionedValue;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:mapService";
    }
}

