/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.merge;

import com.att.aft.dme2.hazelcast.map.merge.HigherHitsMapMergePolicy;
import com.att.aft.dme2.hazelcast.map.merge.LatestUpdateMapMergePolicy;
import com.att.aft.dme2.hazelcast.map.merge.MapMergePolicy;
import com.att.aft.dme2.hazelcast.map.merge.PassThroughMergePolicy;
import com.att.aft.dme2.hazelcast.map.merge.PutIfAbsentMapMergePolicy;
import com.att.aft.dme2.hazelcast.nio.ClassLoaderUtil;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.util.ConcurrencyUtil;
import com.att.aft.dme2.hazelcast.util.ConstructorFunction;
import com.att.aft.dme2.hazelcast.util.ExceptionUtil;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class MergePolicyProvider {
    private final ConcurrentMap<String, MapMergePolicy> mergePolicyMap;
    private final NodeEngine nodeEngine;
    private final ConstructorFunction<String, MapMergePolicy> policyConstructorFunction = new ConstructorFunction<String, MapMergePolicy>(){

        @Override
        public MapMergePolicy createNew(String className) {
            try {
                return (MapMergePolicy)ClassLoaderUtil.newInstance(MergePolicyProvider.this.nodeEngine.getConfigClassLoader(), className);
            }
            catch (Exception e) {
                MergePolicyProvider.this.nodeEngine.getLogger(this.getClass()).severe(e);
                throw ExceptionUtil.rethrow(e);
            }
        }
    };

    public MergePolicyProvider(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.mergePolicyMap = new ConcurrentHashMap<String, MapMergePolicy>();
        this.addOutOfBoxPolicies();
    }

    private void addOutOfBoxPolicies() {
        this.mergePolicyMap.put(PutIfAbsentMapMergePolicy.class.getName(), new PutIfAbsentMapMergePolicy());
        this.mergePolicyMap.put(HigherHitsMapMergePolicy.class.getName(), new HigherHitsMapMergePolicy());
        this.mergePolicyMap.put(PassThroughMergePolicy.class.getName(), new PassThroughMergePolicy());
        this.mergePolicyMap.put(LatestUpdateMapMergePolicy.class.getName(), new LatestUpdateMapMergePolicy());
    }

    public MapMergePolicy getMergePolicy(String className) {
        Preconditions.checkNotNull(className, "Class name is mandatory!");
        return ConcurrencyUtil.getOrPutIfAbsent(this.mergePolicyMap, className, this.policyConstructorFunction);
    }
}

