/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.mapreduce.aggregation.impl;

import com.att.aft.dme2.hazelcast.mapreduce.aggregation.PropertyExtractor;
import com.att.aft.dme2.hazelcast.mapreduce.aggregation.Supplier;
import com.att.aft.dme2.hazelcast.mapreduce.aggregation.impl.AggregationsDataSerializerHook;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Map;

public class AcceptAllSupplier<KeyIn, ValueIn, ValueOut>
extends Supplier<KeyIn, ValueIn, ValueOut>
implements IdentifiedDataSerializable {
    private PropertyExtractor<ValueIn, ValueOut> propertyExtractor;

    AcceptAllSupplier() {
    }

    public AcceptAllSupplier(PropertyExtractor<ValueIn, ValueOut> propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    @Override
    public ValueOut apply(Map.Entry<KeyIn, ValueIn> entry) {
        ValueIn value = entry.getValue();
        return (ValueOut)(this.propertyExtractor != null ? this.propertyExtractor.extract(value) : value);
    }

    @Override
    public int getFactoryId() {
        return AggregationsDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.propertyExtractor);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.propertyExtractor = (PropertyExtractor)in.readObject();
    }
}

