/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.mapreduce.impl;

import com.att.aft.dme2.hazelcast.mapreduce.impl.MapReduceDataSerializerHook;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HashMapAdapter<K, V>
extends HashMap<K, V>
implements IdentifiedDataSerializable {
    public HashMapAdapter(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public HashMapAdapter(int initialCapacity) {
        super(initialCapacity);
    }

    public HashMapAdapter() {
    }

    public HashMapAdapter(Map<? extends K, ? extends V> m) {
        super(m);
    }

    @Override
    public int getFactoryId() {
        return MapReduceDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 22;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        Set entrySet = this.entrySet();
        out.writeInt(entrySet.size());
        for (Map.Entry entry : entrySet) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        HashMap map = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            map.put(key, value);
        }
        this.putAll(map);
    }
}

