/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.mapreduce.impl.notification;

import com.att.aft.dme2.hazelcast.mapreduce.impl.MapReduceDataSerializerHook;
import com.att.aft.dme2.hazelcast.mapreduce.impl.notification.MemberAwareMapReduceNotification;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class IntermediateChunkNotification<KeyOut, Value>
extends MemberAwareMapReduceNotification {
    private Map<KeyOut, Value> chunk;
    private int partitionId;

    public IntermediateChunkNotification() {
    }

    public IntermediateChunkNotification(Address address, String name, String jobId, Map<KeyOut, Value> chunk, int partitionId) {
        super(address, name, jobId);
        this.chunk = chunk;
        this.partitionId = partitionId;
    }

    public Map<KeyOut, Value> getChunk() {
        return this.chunk;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.chunk.size());
        for (Map.Entry<KeyOut, Value> entry : this.chunk.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeInt(this.partitionId);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        int size = in.readInt();
        this.chunk = new HashMap<KeyOut, Value>();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.chunk.put(key, value);
        }
        this.partitionId = in.readInt();
    }

    @Override
    public int getFactoryId() {
        return MapReduceDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public String toString() {
        return "IntermediateChunkNotification{chunk=" + this.chunk + '}';
    }
}

