/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.monitor.impl;

import com.att.aft.dme2.hazelcast.com.eclipsesource.json.JsonObject;
import com.att.aft.dme2.hazelcast.monitor.NearCacheStats;
import com.att.aft.dme2.hazelcast.util.Clock;
import com.att.aft.dme2.hazelcast.util.JsonUtil;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class NearCacheStatsImpl
implements NearCacheStats {
    private static final double PERCENTAGE = 100.0;
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> OWNED_ENTRY_COUNT = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "ownedEntryCount");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> OWNED_ENTRY_MEMORY_COST = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "ownedEntryMemoryCost");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> HITS = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "hits");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> MISSES = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "misses");
    private volatile long creationTime = Clock.currentTimeMillis();
    private volatile long ownedEntryCount;
    private volatile long ownedEntryMemoryCost;
    private volatile long hits;
    private volatile long misses;

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getOwnedEntryCount() {
        return this.ownedEntryCount;
    }

    public void setOwnedEntryCount(long ownedEntryCount) {
        OWNED_ENTRY_COUNT.set(this, ownedEntryCount);
    }

    public void incrementOwnedEntryCount() {
        OWNED_ENTRY_COUNT.incrementAndGet(this);
    }

    public void decrementOwnedEntryCount() {
        OWNED_ENTRY_COUNT.decrementAndGet(this);
    }

    @Override
    public long getOwnedEntryMemoryCost() {
        return this.ownedEntryMemoryCost;
    }

    public void setOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        OWNED_ENTRY_MEMORY_COST.set(this, ownedEntryMemoryCost);
    }

    public void incrementOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        OWNED_ENTRY_MEMORY_COST.addAndGet(this, ownedEntryMemoryCost);
    }

    public void decrementOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        OWNED_ENTRY_MEMORY_COST.addAndGet(this, -ownedEntryMemoryCost);
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    public void incrementHits() {
        HITS.incrementAndGet(this);
    }

    public void setHits(long hits) {
        HITS.set(this, hits);
    }

    @Override
    public long getMisses() {
        return this.misses;
    }

    public void setMisses(long misses) {
        MISSES.set(this, misses);
    }

    public void incrementMisses() {
        MISSES.incrementAndGet(this);
    }

    @Override
    public double getRatio() {
        if (this.misses == 0L) {
            if (this.hits == 0L) {
                return Double.NaN;
            }
            return Double.POSITIVE_INFINITY;
        }
        return (double)this.hits / (double)this.misses * 100.0;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("ownedEntryCount", this.ownedEntryCount);
        root.add("ownedEntryMemoryCost", this.ownedEntryMemoryCost);
        root.add("creationTime", this.creationTime);
        root.add("hits", this.hits);
        root.add("misses", this.misses);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.ownedEntryCount = JsonUtil.getLong(json, "ownedEntryCount", -1L);
        this.ownedEntryMemoryCost = JsonUtil.getLong(json, "ownedEntryMemoryCost", -1L);
        this.creationTime = JsonUtil.getLong(json, "creationTime", -1L);
        this.hits = JsonUtil.getLong(json, "hits", -1L);
        this.misses = JsonUtil.getLong(json, "misses", -1L);
    }

    public String toString() {
        return "NearCacheStatsImpl{ownedEntryCount=" + this.ownedEntryCount + ", ownedEntryMemoryCost=" + this.ownedEntryMemoryCost + ", creationTime=" + this.creationTime + ", hits=" + this.hits + ", misses=" + this.misses + ", ratio=" + String.format("%.1f%%", this.getRatio()) + '}';
    }
}

