/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.multimap.impl;

import com.att.aft.dme2.hazelcast.concurrent.lock.LockService;
import com.att.aft.dme2.hazelcast.concurrent.lock.LockStore;
import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapContainerSupport;
import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapRecord;
import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapService;
import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapValue;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.DefaultObjectNamespace;
import com.att.aft.dme2.hazelcast.util.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class MultiMapContainer
extends MultiMapContainerSupport {
    private static final int ID_PROMOTION_OFFSET = 100000;
    private final DefaultObjectNamespace lockNamespace;
    private final LockStore lockStore;
    private final int partitionId;
    private final long creationTime;
    private long idGen;
    private volatile long lastAccessTime;
    private volatile long lastUpdateTime;

    public MultiMapContainer(String name, MultiMapService service, int partitionId) {
        super(name, service.getNodeEngine());
        this.partitionId = partitionId;
        this.lockNamespace = new DefaultObjectNamespace("hz:impl:multiMapService", name);
        LockService lockService = (LockService)this.nodeEngine.getSharedService("hz:impl:lockService");
        this.lockStore = lockService == null ? null : lockService.createLockStore(partitionId, this.lockNamespace);
        this.creationTime = Clock.currentTimeMillis();
    }

    public boolean canAcquireLock(Data dataKey, String caller, long threadId) {
        return this.lockStore != null && this.lockStore.canAcquireLock(dataKey, caller, threadId);
    }

    public boolean isLocked(Data dataKey) {
        return this.lockStore != null && this.lockStore.isLocked(dataKey);
    }

    public boolean isTransactionallyLocked(Data key) {
        return this.lockStore != null && this.lockStore.shouldBlockReads(key);
    }

    public boolean txnLock(Data key, String caller, long threadId, long referenceId, long ttl, boolean blockReads) {
        return this.lockStore != null && this.lockStore.txnLock(key, caller, threadId, referenceId, ttl, blockReads);
    }

    public boolean unlock(Data key, String caller, long threadId, long referenceId) {
        return this.lockStore != null && this.lockStore.unlock(key, caller, threadId, referenceId);
    }

    public boolean forceUnlock(Data key) {
        return this.lockStore != null && this.lockStore.forceUnlock(key);
    }

    public boolean extendLock(Data key, String caller, long threadId, long ttl) {
        return this.lockStore != null && this.lockStore.extendLeaseTime(key, caller, threadId, ttl);
    }

    public String getLockOwnerInfo(Data dataKey) {
        return this.lockStore != null ? this.lockStore.getOwnerInfo(dataKey) : null;
    }

    public long nextId() {
        return this.idGen++;
    }

    public void setId(long newValue) {
        this.idGen = newValue + 100000L;
    }

    public void delete(Data dataKey) {
        this.multiMapValues.remove(dataKey);
    }

    public Collection<MultiMapRecord> remove(Data dataKey, boolean copyOf) {
        MultiMapValue multiMapValue = (MultiMapValue)this.multiMapValues.remove(dataKey);
        return multiMapValue != null ? multiMapValue.getCollection(copyOf) : null;
    }

    public Set<Data> keySet() {
        Set keySet = this.multiMapValues.keySet();
        HashSet<Data> keys = new HashSet<Data>(keySet.size());
        keys.addAll(keySet);
        return keys;
    }

    public Collection<MultiMapRecord> values() {
        LinkedList<MultiMapRecord> valueCollection = new LinkedList<MultiMapRecord>();
        for (MultiMapValue multiMapValue : this.multiMapValues.values()) {
            valueCollection.addAll(multiMapValue.getCollection(false));
        }
        return valueCollection;
    }

    public boolean containsKey(Data key) {
        return this.multiMapValues.containsKey(key);
    }

    public boolean containsEntry(boolean binary, Data key, Data value) {
        MultiMapValue multiMapValue = (MultiMapValue)this.multiMapValues.get(key);
        if (multiMapValue == null) {
            return false;
        }
        MultiMapRecord record = new MultiMapRecord(binary ? value : this.nodeEngine.toObject(value));
        return multiMapValue.getCollection(false).contains(record);
    }

    public boolean containsValue(boolean binary, Data value) {
        for (Data key : this.multiMapValues.keySet()) {
            if (!this.containsEntry(binary, key, value)) continue;
            return true;
        }
        return false;
    }

    public Map<Data, Collection<MultiMapRecord>> copyCollections() {
        HashMap<Data, Collection<MultiMapRecord>> map = new HashMap<Data, Collection<MultiMapRecord>>(this.multiMapValues.size());
        for (Map.Entry entry : this.multiMapValues.entrySet()) {
            Data key = (Data)entry.getKey();
            Collection<MultiMapRecord> col = ((MultiMapValue)entry.getValue()).getCollection(true);
            map.put(key, col);
        }
        return map;
    }

    public int size() {
        int size = 0;
        for (MultiMapValue multiMapValue : this.multiMapValues.values()) {
            size += multiMapValue.getCollection(false).size();
        }
        return size;
    }

    public int clear() {
        Set<Data> locks = this.lockStore != null ? this.lockStore.getLockedKeys() : Collections.emptySet();
        HashMap<Data, MultiMapValue> lockedKeys = new HashMap<Data, MultiMapValue>(locks.size());
        for (Data key : locks) {
            MultiMapValue multiMapValue = (MultiMapValue)this.multiMapValues.get(key);
            if (multiMapValue == null) continue;
            lockedKeys.put(key, multiMapValue);
        }
        int numberOfAffectedEntries = this.multiMapValues.size() - lockedKeys.size();
        this.multiMapValues.clear();
        this.multiMapValues.putAll(lockedKeys);
        return numberOfAffectedEntries;
    }

    public void destroy() {
        LockService lockService = (LockService)this.nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            lockService.clearLockStore(this.partitionId, this.lockNamespace);
        }
        this.multiMapValues.clear();
    }

    public void access() {
        this.lastAccessTime = Clock.currentTimeMillis();
    }

    public void update() {
        this.lastUpdateTime = Clock.currentTimeMillis();
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLockedCount() {
        return this.lockStore.getLockedKeys().size();
    }
}

