/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.multimap.impl;

import com.att.aft.dme2.hazelcast.concurrent.lock.LockService;
import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapContainer;
import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapService;
import com.att.aft.dme2.hazelcast.spi.DefaultObjectNamespace;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.util.ConcurrencyUtil;
import com.att.aft.dme2.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MultiMapPartitionContainer {
    final int partitionId;
    final MultiMapService service;
    final ConcurrentMap<String, MultiMapContainer> containerMap = new ConcurrentHashMap<String, MultiMapContainer>(1000);
    private final ConstructorFunction<String, MultiMapContainer> containerConstructor = new ConstructorFunction<String, MultiMapContainer>(){

        @Override
        public MultiMapContainer createNew(String name) {
            return new MultiMapContainer(name, MultiMapPartitionContainer.this.service, MultiMapPartitionContainer.this.partitionId);
        }
    };

    public MultiMapPartitionContainer(MultiMapService service, int partitionId) {
        this.service = service;
        this.partitionId = partitionId;
    }

    public MultiMapContainer getOrCreateMultiMapContainer(String name) {
        MultiMapContainer container = ConcurrencyUtil.getOrPutIfAbsent(this.containerMap, name, this.containerConstructor);
        container.access();
        return container;
    }

    public MultiMapContainer getCollectionContainer(String name) {
        MultiMapContainer container = (MultiMapContainer)this.containerMap.get(name);
        if (container != null) {
            container.access();
        }
        return container;
    }

    public boolean containsCollection(String name) {
        return this.containerMap.containsKey(name);
    }

    void destroyCollection(String name) {
        MultiMapContainer container = (MultiMapContainer)this.containerMap.remove(name);
        if (container != null) {
            container.destroy();
        } else {
            this.clearLockStore(name);
        }
    }

    private void clearLockStore(String name) {
        NodeEngine nodeEngine = this.service.getNodeEngine();
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            DefaultObjectNamespace namespace = new DefaultObjectNamespace("hz:impl:multiMapService", name);
            lockService.clearLockStore(this.partitionId, namespace);
        }
    }

    void destroy() {
        for (MultiMapContainer container : this.containerMap.values()) {
            container.destroy();
        }
        this.containerMap.clear();
    }
}

