/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.multimap.impl.operations;

import com.att.aft.dme2.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.att.aft.dme2.hazelcast.core.OperationTimeoutException;
import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapContainer;
import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapService;
import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapValue;
import com.att.aft.dme2.hazelcast.multimap.impl.operations.MultiMapKeyBasedOperation;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.BlockingOperation;
import com.att.aft.dme2.hazelcast.spi.DefaultObjectNamespace;
import com.att.aft.dme2.hazelcast.spi.WaitNotifyKey;

public class CountOperation
extends MultiMapKeyBasedOperation
implements BlockingOperation {
    public CountOperation() {
    }

    public CountOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    @Override
    public void run() throws Exception {
        MultiMapContainer container = this.getOrCreateContainer();
        ((MultiMapService)this.getService()).getLocalMultiMapStatsImpl(this.name).incrementOtherOperations();
        MultiMapValue multiMapValue = container.getMultiMapValueOrNull(this.dataKey);
        this.response = multiMapValue == null ? 0 : multiMapValue.getCollection(false).size();
    }

    @Override
    public int getId() {
        return 9;
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(new DefaultObjectNamespace("hz:impl:multiMapService", this.name), this.dataKey);
    }

    @Override
    public boolean shouldWait() {
        MultiMapContainer container = this.getOrCreateContainer();
        if (container.isTransactionallyLocked(this.dataKey)) {
            return !container.canAcquireLock(this.dataKey, this.getCallerUuid(), this.threadId);
        }
        return false;
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(new OperationTimeoutException("Cannot read transactionally locked entry!"));
    }
}

