/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.multimap.impl.operations;

import com.att.aft.dme2.hazelcast.config.MultiMapConfig;
import com.att.aft.dme2.hazelcast.core.EntryEventType;
import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapContainer;
import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapRecord;
import com.att.aft.dme2.hazelcast.multimap.impl.operations.MultiMapBackupAwareOperation;
import com.att.aft.dme2.hazelcast.multimap.impl.operations.MultiMapResponse;
import com.att.aft.dme2.hazelcast.multimap.impl.operations.RemoveAllBackupOperation;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.Operation;
import java.util.Collection;

public class RemoveAllOperation
extends MultiMapBackupAwareOperation {
    private Collection<MultiMapRecord> coll;

    public RemoveAllOperation() {
    }

    public RemoveAllOperation(String name, Data dataKey, long threadId) {
        super(name, dataKey, threadId);
    }

    @Override
    public void run() throws Exception {
        MultiMapContainer container = this.getOrCreateContainer();
        this.coll = this.remove(this.getOperationResponseHandler().isLocal());
        this.response = new MultiMapResponse(this.coll, this.getValueCollectionType(container));
    }

    @Override
    public void afterRun() throws Exception {
        if (this.coll != null) {
            this.getOrCreateContainer().update();
            for (MultiMapRecord record : this.coll) {
                this.publishEvent(EntryEventType.REMOVED, this.dataKey, null, record.getObject());
            }
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.coll != null;
    }

    @Override
    public Operation getBackupOperation() {
        return new RemoveAllBackupOperation(this.name, this.dataKey);
    }

    @Override
    public void onWaitExpire() {
        MultiMapContainer container = this.getOrCreateContainer();
        MultiMapConfig.ValueCollectionType valueCollectionType = this.getValueCollectionType(container);
        this.sendResponse(new MultiMapResponse(null, valueCollectionType));
    }

    @Override
    public int getId() {
        return 18;
    }
}

