/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.multimap.impl.operations;

import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapRecord;
import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapValue;
import com.att.aft.dme2.hazelcast.multimap.impl.operations.MultiMapKeyBasedOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.BackupOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class RemoveBackupOperation
extends MultiMapKeyBasedOperation
implements BackupOperation {
    long recordId;

    public RemoveBackupOperation() {
    }

    public RemoveBackupOperation(String name, Data dataKey, long recordId) {
        super(name, dataKey);
        this.recordId = recordId;
    }

    @Override
    public void run() throws Exception {
        MultiMapValue multiMapValue = this.getMultiMapValueOrNull();
        this.response = false;
        if (multiMapValue == null) {
            return;
        }
        Collection<MultiMapRecord> coll = multiMapValue.getCollection(false);
        Iterator<MultiMapRecord> iter = coll.iterator();
        while (iter.hasNext()) {
            if (iter.next().getRecordId() != this.recordId) continue;
            iter.remove();
            this.response = true;
            if (!coll.isEmpty()) break;
            this.delete();
            break;
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.recordId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.recordId = in.readLong();
    }

    @Override
    public int getId() {
        return 19;
    }
}

