/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.multimap.impl.operations;

import com.att.aft.dme2.hazelcast.core.EntryEventType;
import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapRecord;
import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapValue;
import com.att.aft.dme2.hazelcast.multimap.impl.operations.MultiMapBackupAwareOperation;
import com.att.aft.dme2.hazelcast.multimap.impl.operations.RemoveBackupOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class RemoveOperation
extends MultiMapBackupAwareOperation {
    private Data value;
    private long recordId;

    public RemoveOperation() {
    }

    public RemoveOperation(String name, Data dataKey, long threadId, Data value) {
        super(name, dataKey, threadId);
        this.value = value;
    }

    @Override
    public void run() throws Exception {
        this.response = false;
        MultiMapValue multiMapValue = this.getMultiMapValueOrNull();
        if (multiMapValue == null) {
            return;
        }
        Collection<MultiMapRecord> coll = multiMapValue.getCollection(false);
        MultiMapRecord record = new MultiMapRecord(this.isBinary() ? this.value : this.toObject(this.value));
        Iterator<MultiMapRecord> iter = coll.iterator();
        while (iter.hasNext()) {
            MultiMapRecord r = iter.next();
            if (!r.equals(record)) continue;
            iter.remove();
            this.recordId = r.getRecordId();
            this.response = true;
            if (!coll.isEmpty()) break;
            this.delete();
            break;
        }
    }

    @Override
    public void afterRun() throws Exception {
        if (Boolean.TRUE.equals(this.response)) {
            this.getOrCreateContainer().update();
            this.publishEvent(EntryEventType.REMOVED, this.dataKey, null, this.value);
        }
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public Operation getBackupOperation() {
        return new RemoveBackupOperation(this.name, this.dataKey, this.recordId);
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(false);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeData(this.value);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.value = in.readData();
    }

    @Override
    public int getId() {
        return 20;
    }
}

