/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.multimap.impl.txn;

import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapContainer;
import com.att.aft.dme2.hazelcast.multimap.impl.operations.MultiMapKeyBasedOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.BackupOperation;
import com.att.aft.dme2.hazelcast.transaction.TransactionException;
import java.io.IOException;

public class TxnPrepareBackupOperation
extends MultiMapKeyBasedOperation
implements BackupOperation {
    private static final long LOCK_EXTENSION_TIME_IN_MILLIS = 10000L;
    String caller;
    long ttl;

    public TxnPrepareBackupOperation() {
    }

    public TxnPrepareBackupOperation(String name, Data dataKey, String caller, long threadId) {
        super(name, dataKey);
        this.caller = caller;
        this.threadId = threadId;
    }

    @Override
    public void run() throws Exception {
        MultiMapContainer container = this.getOrCreateContainer();
        if (!container.txnLock(this.dataKey, this.caller, this.threadId, this.getCallId(), this.ttl + 10000L, true)) {
            throw new TransactionException("Lock is not owned by the transaction! -> " + container.getLockOwnerInfo(this.dataKey));
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.caller);
        out.writeLong(this.ttl);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.caller = in.readUTF();
        this.ttl = in.readLong();
    }

    @Override
    public int getId() {
        return 31;
    }
}

