/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.multimap.impl.txn;

import com.att.aft.dme2.hazelcast.multimap.impl.MultiMapContainer;
import com.att.aft.dme2.hazelcast.multimap.impl.operations.MultiMapBackupAwareOperation;
import com.att.aft.dme2.hazelcast.multimap.impl.txn.TxnRollbackBackupOperation;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.Notifier;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.WaitNotifyKey;
import com.att.aft.dme2.hazelcast.transaction.TransactionException;

public class TxnRollbackOperation
extends MultiMapBackupAwareOperation
implements Notifier {
    public TxnRollbackOperation() {
    }

    public TxnRollbackOperation(int partitionId, String name, Data dataKey, long threadId) {
        super(name, dataKey, threadId);
        this.setPartitionId(partitionId);
    }

    @Override
    public void run() throws Exception {
        MultiMapContainer container = this.getOrCreateContainer();
        if (container.isLocked(this.dataKey) && !container.unlock(this.dataKey, this.getCallerUuid(), this.threadId, this.getCallId())) {
            throw new TransactionException("Lock is not owned by the transaction! Owner: " + container.getLockOwnerInfo(this.dataKey));
        }
    }

    @Override
    public Operation getBackupOperation() {
        return new TxnRollbackBackupOperation(this.name, this.dataKey, this.getCallerUuid(), this.threadId);
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.getWaitKey();
    }

    @Override
    public int getId() {
        return 39;
    }
}

