/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.nio.tcp;

import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.IOService;
import com.att.aft.dme2.hazelcast.nio.tcp.SocketChannelWrapper;
import com.att.aft.dme2.hazelcast.nio.tcp.TcpIpConnection;
import com.att.aft.dme2.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.att.aft.dme2.hazelcast.util.AddressUtil;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.logging.Level;

public class InitConnectionTask
implements Runnable {
    private static final int DEFAULT_IPV6_SOCKET_CONNECT_TIMEOUT_SECONDS = 3;
    private static final int MILLIS_PER_SECOND = 1000;
    private final TcpIpConnectionManager connectionManager;
    private final Address address;
    private final ILogger logger;
    private final boolean silent;
    private final IOService ioService;

    public InitConnectionTask(TcpIpConnectionManager connectionManager, Address address, boolean silent) {
        this.connectionManager = connectionManager;
        this.ioService = connectionManager.getIoService();
        this.address = address;
        this.logger = this.ioService.getLogger(this.getClass().getName());
        this.silent = silent;
    }

    @Override
    public void run() {
        if (!this.connectionManager.isLive()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("ConnectionManager is not live, connection attempt to " + this.address + " is cancelled!");
            }
            return;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Starting to connect to " + this.address);
        }
        try {
            Address thisAddress = this.ioService.getThisAddress();
            if (this.address.isIPv4()) {
                this.tryToConnect(this.address.getInetSocketAddress(), this.ioService.getSocketConnectTimeoutSeconds() * 1000);
            } else if (thisAddress.isIPv6() && thisAddress.getScopeId() != null) {
                Inet6Address inetAddress = AddressUtil.getInetAddressFor((Inet6Address)this.address.getInetAddress(), thisAddress.getScopeId());
                this.tryToConnect(new InetSocketAddress(inetAddress, this.address.getPort()), this.ioService.getSocketConnectTimeoutSeconds() * 1000);
            } else {
                this.tryConnectToIPv6();
            }
        }
        catch (Throwable e) {
            this.logger.finest(e);
            this.connectionManager.failedConnection(this.address, e, this.silent);
        }
    }

    private void tryConnectToIPv6() throws Exception {
        Level level;
        Collection<Inet6Address> possibleInetAddresses = AddressUtil.getPossibleInetAddressesFor((Inet6Address)this.address.getInetAddress());
        Level level2 = level = this.silent ? Level.FINEST : Level.INFO;
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, "Trying to connect possible IPv6 addresses: " + possibleInetAddresses);
        }
        boolean connected = false;
        Exception error = null;
        int configuredTimeoutMillis = this.ioService.getSocketConnectTimeoutSeconds() * 1000;
        int timeoutMillis = configuredTimeoutMillis > 0 && configuredTimeoutMillis < Integer.MAX_VALUE ? configuredTimeoutMillis : 3000;
        for (Inet6Address inetAddress : possibleInetAddresses) {
            try {
                this.tryToConnect(new InetSocketAddress(inetAddress, this.address.getPort()), timeoutMillis);
                connected = true;
                break;
            }
            catch (Exception e) {
                error = e;
            }
        }
        if (!connected && error != null) {
            throw error;
        }
    }

    private void tryToConnect(InetSocketAddress socketAddress, int timeout) throws Exception {
        Level level;
        SocketChannel socketChannel = SocketChannel.open();
        this.connectionManager.initSocket(socketChannel.socket());
        if (this.ioService.isSocketBind()) {
            this.bindSocket(socketChannel);
        }
        Level level2 = level = this.silent ? Level.FINEST : Level.INFO;
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, "Connecting to " + socketAddress + ", timeout: " + timeout + ", bind-any: " + this.ioService.isSocketBindAny());
        }
        try {
            socketChannel.configureBlocking(true);
            this.connectSocketChannel(socketAddress, timeout, socketChannel);
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Successfully connected to: " + this.address + " using socket " + socketChannel.socket());
            }
            SocketChannelWrapper socketChannelWrapper = this.connectionManager.wrapSocketChannel(socketChannel, true);
            this.connectionManager.interceptSocket(socketChannel.socket(), false);
            socketChannelWrapper.configureBlocking(false);
            TcpIpConnection connection = this.connectionManager.newConnection(socketChannelWrapper, this.address);
            connection.getSocketWriter().setProtocol("HZC");
            this.connectionManager.sendBindRequest(connection, this.address, true);
        }
        catch (Exception e) {
            this.closeSocket(socketChannel);
            this.logger.log(level, "Could not connect to: " + socketAddress + ". Reason: " + e.getClass().getSimpleName() + "[" + e.getMessage() + "]");
            throw e;
        }
    }

    private void connectSocketChannel(InetSocketAddress address, int timeout, SocketChannel socketChannel) throws IOException {
        try {
            if (timeout > 0) {
                socketChannel.socket().connect(address, timeout);
            } else {
                socketChannel.connect(address);
            }
        }
        catch (SocketException ex) {
            SocketException newEx = new SocketException(ex.getMessage() + " to address " + address);
            newEx.setStackTrace(ex.getStackTrace());
            throw newEx;
        }
    }

    private void bindSocket(SocketChannel socketChannel) throws IOException {
        InetAddress inetAddress = this.getInetAddress();
        Socket socket = socketChannel.socket();
        if (!this.connectionManager.useAnyOutboundPort()) {
            IOException ex = null;
            int retryCount = this.connectionManager.getOutboundPortCount() * 2;
            for (int i = 0; i < retryCount; ++i) {
                int port = this.connectionManager.acquireOutboundPort();
                InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, port);
                try {
                    socket.bind(socketAddress);
                    return;
                }
                catch (IOException e) {
                    ex = e;
                    this.logger.finest("Could not bind port[ " + port + "]: " + e.getMessage());
                    continue;
                }
            }
            throw ex;
        }
        InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, 0);
        socket.bind(socketAddress);
    }

    private InetAddress getInetAddress() throws UnknownHostException {
        if (this.ioService.isSocketBindAny()) {
            return null;
        }
        return this.ioService.getThisAddress().getInetAddress();
    }

    private void closeSocket(SocketChannel socketChannel) {
        if (socketChannel != null) {
            try {
                socketChannel.close();
            }
            catch (IOException e) {
                this.logger.finest("Closing socket channel failed", e);
            }
        }
    }
}

