/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.nio.tcp.nonblocking;

import com.att.aft.dme2.hazelcast.core.HazelcastException;
import com.att.aft.dme2.hazelcast.internal.metrics.Probe;
import com.att.aft.dme2.hazelcast.internal.metrics.ProbeLevel;
import com.att.aft.dme2.hazelcast.internal.util.counters.SwCounter;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.tcp.nonblocking.AbstractHandler;
import com.att.aft.dme2.hazelcast.nio.tcp.nonblocking.MigratableHandler;
import com.att.aft.dme2.hazelcast.nio.tcp.nonblocking.NonBlockingIOThreadOutOfMemoryHandler;
import com.att.aft.dme2.hazelcast.nio.tcp.nonblocking.SelectionHandler;
import com.att.aft.dme2.hazelcast.nio.tcp.nonblocking.SelectorMode;
import com.att.aft.dme2.hazelcast.nio.tcp.nonblocking.SelectorOptimizer;
import com.att.aft.dme2.hazelcast.spi.impl.operationexecutor.OperationHostileThread;
import com.att.aft.dme2.hazelcast.util.EmptyStatement;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;

public class NonBlockingIOThread
extends Thread
implements OperationHostileThread {
    private static final int SELECT_WAIT_TIME_MILLIS = 5000;
    private static final int SELECT_FAILURE_PAUSE_MILLIS = 1000;
    private static final int SELECT_IDLE_COUNT_THRESHOLD = 10;
    private static final Random RANDOM = new Random();
    private static final int TEST_SELECTOR_BUG_PROBABILITY = Integer.parseInt(System.getProperty("hazelcast.io.selector.bug.probability", "16"));
    @Probe(name="ioThreadId", level=ProbeLevel.INFO)
    public int id;
    @Probe(name="taskQueueSize")
    private final Queue<Runnable> taskQueue = new ConcurrentLinkedQueue<Runnable>();
    @Probe
    private final SwCounter eventCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter selectorIOExceptionCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter completedTaskCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter selectorRebuildCount = SwCounter.newSwCounter();
    private final ILogger logger;
    private Selector selector;
    private final NonBlockingIOThreadOutOfMemoryHandler oomeHandler;
    private final SelectorMode selectMode;
    private volatile long lastSelectTimeMs;
    private boolean selectorWorkaroundTest;

    public NonBlockingIOThread(ThreadGroup threadGroup, String threadName, ILogger logger, NonBlockingIOThreadOutOfMemoryHandler oomeHandler) {
        this(threadGroup, threadName, logger, oomeHandler, SelectorMode.SELECT);
    }

    public NonBlockingIOThread(ThreadGroup threadGroup, String threadName, ILogger logger, NonBlockingIOThreadOutOfMemoryHandler oomeHandler, SelectorMode selectMode) {
        this(threadGroup, threadName, logger, oomeHandler, selectMode, NonBlockingIOThread.newSelector(logger));
    }

    public NonBlockingIOThread(ThreadGroup threadGroup, String threadName, ILogger logger, NonBlockingIOThreadOutOfMemoryHandler oomeHandler, SelectorMode selectMode, Selector selector) {
        super(threadGroup, threadName);
        this.logger = logger;
        this.selectMode = selectMode;
        this.oomeHandler = oomeHandler;
        this.selector = selector;
        this.selectorWorkaroundTest = false;
    }

    private static Selector newSelector(ILogger logger) {
        try {
            Selector selector = Selector.open();
            if (Boolean.getBoolean("tcp.optimizedselector")) {
                SelectorOptimizer.optimize(selector, logger);
            }
            return selector;
        }
        catch (IOException e) {
            throw new HazelcastException("Failed to open a Selector", e);
        }
    }

    public final Selector getSelector() {
        return this.selector;
    }

    public long getEventCount() {
        return this.eventCount.get();
    }

    @Probe
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastSelectTimeMs, 0L);
    }

    public final void addTask(Runnable task) {
        this.taskQueue.add(task);
    }

    public void addTaskAndWakeup(Runnable task) {
        this.taskQueue.add(task);
        if (this.selectMode != SelectorMode.SELECT_NOW) {
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            while (true) {
                try {
                    switch (this.selectMode) {
                        case SELECT_WITH_FIX: {
                            this.selectLoopWithFix();
                            break;
                        }
                        case SELECT_NOW: {
                            this.selectNowLoop();
                            break;
                        }
                        case SELECT: {
                            this.selectLoop();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Selector.select mode not set, use -Dhazelcast.io.selectorMode={select|selectnow|selectwithfix} to explicitly specify select mode or leave empty for default select mode.");
                        }
                    }
                }
                catch (IOException nonFatalException) {
                    this.selectorIOExceptionCount.inc();
                    this.logger.warning(this.getName() + " " + nonFatalException.toString(), nonFatalException);
                    this.coolDown();
                    continue;
                }
                break;
            }
        }
        catch (OutOfMemoryError e) {
            this.oomeHandler.handle(e);
        }
        catch (Throwable e) {
            this.logger.warning("Unhandled exception in " + this.getName(), e);
        }
        finally {
            this.closeSelector();
        }
        this.logger.finest(this.getName() + " finished");
    }

    private void coolDown() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            this.interrupt();
        }
    }

    private void selectLoop() throws IOException {
        while (!this.isInterrupted()) {
            this.processTaskQueue();
            int selectedKeys = this.selector.select(5000L);
            if (selectedKeys <= 0) continue;
            this.handleSelectionKeys();
        }
    }

    private void selectLoopWithFix() throws IOException {
        int idleCount = 0;
        while (!this.isInterrupted()) {
            this.processTaskQueue();
            long before = System.currentTimeMillis();
            int selectedKeys = this.selector.select(5000L);
            if (selectedKeys > 0) {
                idleCount = 0;
                this.handleSelectionKeys();
                continue;
            }
            if (!this.taskQueue.isEmpty()) {
                idleCount = 0;
                continue;
            }
            long selectTimeTaken = System.currentTimeMillis() - before;
            idleCount = selectTimeTaken < 5000L ? idleCount + 1 : 0;
            if (!this.selectorBugDetected(idleCount)) continue;
            this.rebuildSelector();
            idleCount = 0;
        }
    }

    private boolean selectorBugDetected(int idleCount) {
        return idleCount > 10 || this.selectorWorkaroundTest && RANDOM.nextInt(TEST_SELECTOR_BUG_PROBABILITY) == 1;
    }

    private void selectNowLoop() throws IOException {
        while (!this.isInterrupted()) {
            this.processTaskQueue();
            int selectedKeys = this.selector.selectNow();
            if (selectedKeys <= 0) continue;
            this.handleSelectionKeys();
        }
    }

    private void processTaskQueue() {
        while (!this.isInterrupted()) {
            Runnable task = this.taskQueue.poll();
            if (task == null) {
                return;
            }
            this.executeTask(task);
        }
    }

    private void executeTask(Runnable task) {
        this.completedTaskCount.inc();
        NonBlockingIOThread target = this.getTargetIOThread(task);
        if (target == this) {
            task.run();
        } else {
            target.addTaskAndWakeup(task);
        }
    }

    private NonBlockingIOThread getTargetIOThread(Runnable task) {
        if (task instanceof MigratableHandler) {
            return ((MigratableHandler)((Object)task)).getOwner();
        }
        return this;
    }

    private void handleSelectionKeys() {
        this.lastSelectTimeMs = System.currentTimeMillis();
        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey sk = it.next();
            it.remove();
            this.handleSelectionKey(sk);
        }
    }

    protected void handleSelectionKey(SelectionKey sk) {
        SelectionHandler handler = (SelectionHandler)sk.attachment();
        try {
            if (!sk.isValid()) {
                throw new CancelledKeyException();
            }
            this.eventCount.inc();
            handler.handle();
        }
        catch (Throwable t) {
            handler.onFailure(t);
        }
    }

    private void closeSelector() {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Closing selector for:" + this.getName());
        }
        try {
            this.selector.close();
        }
        catch (Exception e) {
            this.logger.finest("Failed to close selector", e);
        }
    }

    public final void shutdown() {
        this.taskQueue.clear();
        this.interrupt();
    }

    private void rebuildSelector() {
        this.selectorRebuildCount.inc();
        Selector newSelector = NonBlockingIOThread.newSelector(this.logger);
        Selector oldSelector = this.selector;
        for (SelectionKey key : oldSelector.keys()) {
            AbstractHandler handler = (AbstractHandler)key.attachment();
            SelectableChannel channel = key.channel();
            try {
                int ops = key.interestOps();
                SelectionKey newSelectionKey = channel.register(newSelector, ops, handler);
                handler.setSelectionKey(newSelectionKey);
            }
            catch (ClosedChannelException e) {
                this.logger.info("Channel was closed while trying to register with new selector.");
            }
            catch (CancelledKeyException e) {
                EmptyStatement.ignore(e);
            }
            key.cancel();
        }
        this.closeSelector();
        this.selector = newSelector;
        this.logger.warning("Recreated Selector because of possible java/network stack bug.");
    }

    @Override
    public String toString() {
        return this.getName();
    }

    void setSelectorWorkaroundTest(boolean selectorWorkaroundTest) {
        this.selectorWorkaroundTest = selectorWorkaroundTest;
    }
}

