/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.nio.tcp.nonblocking;

import com.att.aft.dme2.hazelcast.internal.metrics.MetricsRegistry;
import com.att.aft.dme2.hazelcast.internal.metrics.Probe;
import com.att.aft.dme2.hazelcast.internal.util.counters.Counter;
import com.att.aft.dme2.hazelcast.internal.util.counters.SwCounter;
import com.att.aft.dme2.hazelcast.nio.ConnectionType;
import com.att.aft.dme2.hazelcast.nio.IOUtil;
import com.att.aft.dme2.hazelcast.nio.ascii.TextReadHandler;
import com.att.aft.dme2.hazelcast.nio.tcp.ClientReadHandler;
import com.att.aft.dme2.hazelcast.nio.tcp.ReadHandler;
import com.att.aft.dme2.hazelcast.nio.tcp.SocketReader;
import com.att.aft.dme2.hazelcast.nio.tcp.SocketWriter;
import com.att.aft.dme2.hazelcast.nio.tcp.TcpIpConnection;
import com.att.aft.dme2.hazelcast.nio.tcp.nonblocking.AbstractHandler;
import com.att.aft.dme2.hazelcast.nio.tcp.nonblocking.NonBlockingIOThread;
import com.att.aft.dme2.hazelcast.util.StringUtil;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;

public final class NonBlockingSocketReader
extends AbstractHandler
implements SocketReader {
    @Probe(name="eventCount")
    private final SwCounter eventCount = SwCounter.newSwCounter();
    @Probe(name="bytesRead")
    private final SwCounter bytesRead = SwCounter.newSwCounter();
    @Probe(name="normalFramesRead")
    private final SwCounter normalFramesRead = SwCounter.newSwCounter();
    @Probe(name="priorityFramesRead")
    private final SwCounter priorityFramesRead = SwCounter.newSwCounter();
    private final MetricsRegistry metricRegistry;
    private ReadHandler readHandler;
    private ByteBuffer inputBuffer;
    private volatile long lastReadTime;

    public NonBlockingSocketReader(TcpIpConnection connection, NonBlockingIOThread ioThread, MetricsRegistry metricsRegistry) {
        super(connection, ioThread, 1);
        this.ioThread = ioThread;
        this.metricRegistry = metricsRegistry;
        this.metricRegistry.scanAndRegister(this, "tcp.connection[" + connection.getMetricsId() + "].in");
    }

    @Probe(name="idleTimeMs")
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastReadTime, 0L);
    }

    @Override
    public Counter getNormalFramesReadCounter() {
        return this.normalFramesRead;
    }

    @Override
    public Counter getPriorityFramesReadCounter() {
        return this.priorityFramesRead;
    }

    @Override
    public long getLastReadTimeMillis() {
        return this.lastReadTime;
    }

    @Override
    public long getEventCount() {
        return this.eventCount.get();
    }

    @Override
    public void init() {
        this.ioThread.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                try {
                    NonBlockingSocketReader.this.getSelectionKey();
                }
                catch (Throwable t) {
                    NonBlockingSocketReader.this.onFailure(t);
                }
            }
        });
    }

    @Override
    public void requestMigration(NonBlockingIOThread newOwner) {
        this.ioThread.addTaskAndWakeup(new StartMigrationTask(newOwner));
    }

    @Override
    public void handle() throws Exception {
        int readBytes;
        this.eventCount.inc();
        this.lastReadTime = System.currentTimeMillis();
        if (this.readHandler == null) {
            this.initReadHandler();
            if (this.readHandler == null) {
                return;
            }
        }
        if ((readBytes = this.socketChannel.read(this.inputBuffer)) <= 0) {
            if (readBytes == -1) {
                throw new EOFException("Remote socket closed!");
            }
            return;
        }
        this.bytesRead.inc(readBytes);
        this.inputBuffer.flip();
        this.readHandler.onRead(this.inputBuffer);
        if (this.inputBuffer.hasRemaining()) {
            this.inputBuffer.compact();
        } else {
            this.inputBuffer.clear();
        }
    }

    private void initReadHandler() throws IOException {
        if (this.readHandler != null) {
            return;
        }
        ByteBuffer protocolBuffer = ByteBuffer.allocate(3);
        int readBytes = this.socketChannel.read(protocolBuffer);
        if (readBytes == -1) {
            throw new EOFException("Could not read protocol type!");
        }
        if (readBytes == 0 && this.connectionManager.isSSLEnabled()) {
            return;
        }
        if (!protocolBuffer.hasRemaining()) {
            String protocol = StringUtil.bytesToString(protocolBuffer.array());
            SocketWriter socketWriter = this.connection.getSocketWriter();
            if ("HZC".equals(protocol)) {
                this.configureBuffers(this.ioService.getSocketReceiveBufferSize() * 1024);
                this.connection.setType(ConnectionType.MEMBER);
                socketWriter.setProtocol("HZC");
                this.readHandler = this.ioService.createReadHandler(this.connection);
            } else if ("CB2".equals(protocol)) {
                this.configureBuffers(this.ioService.getSocketClientReceiveBufferSize() * 1024);
                socketWriter.setProtocol("CB2");
                this.readHandler = new ClientReadHandler(this.connection, this.ioService);
            } else {
                this.configureBuffers(this.ioService.getSocketReceiveBufferSize() * 1024);
                socketWriter.setProtocol("TXT");
                this.inputBuffer.put(protocolBuffer.array());
                this.readHandler = new TextReadHandler(this.connection);
                this.connection.getConnectionManager().incrementTextConnections();
            }
        }
        if (this.readHandler == null) {
            throw new IOException("Could not initialize ReadHandler!");
        }
    }

    private void configureBuffers(int size) {
        this.inputBuffer = IOUtil.newByteBuffer(size, this.ioService.isSocketBufferDirect());
        try {
            this.connection.setReceiveBufferSize(size);
        }
        catch (SocketException e) {
            this.logger.finest("Failed to adjust TCP receive buffer of " + this.connection + " to " + size + " B.", e);
        }
    }

    @Override
    public void close() {
        this.metricRegistry.deregister(this);
        this.ioThread.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                try {
                    NonBlockingSocketReader.this.socketChannel.closeInbound();
                }
                catch (IOException e) {
                    NonBlockingSocketReader.this.logger.finest("Error while closing inbound", e);
                }
            }
        });
    }

    public String toString() {
        return this.connection + ".socketReader";
    }

    private class StartMigrationTask
    implements Runnable {
        private final NonBlockingIOThread newOwner;

        public StartMigrationTask(NonBlockingIOThread newOwner) {
            this.newOwner = newOwner;
        }

        @Override
        public void run() {
            if (NonBlockingSocketReader.this.ioThread == this.newOwner) {
                return;
            }
            try {
                NonBlockingSocketReader.this.startMigration(this.newOwner);
            }
            catch (Throwable t) {
                NonBlockingSocketReader.this.onFailure(t);
            }
        }
    }
}

