/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.nio.tcp.nonblocking.iobalancer;

import com.att.aft.dme2.hazelcast.instance.HazelcastThreadGroup;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.tcp.nonblocking.iobalancer.IOBalancer;
import com.att.aft.dme2.hazelcast.util.EmptyStatement;
import java.util.concurrent.TimeUnit;

class IOBalancerThread
extends Thread {
    private static final String THREAD_NAME_PREFIX = "IOBalancerThread";
    private final IOBalancer ioBalancer;
    private final ILogger log;
    private final int balancerIntervalSeconds;
    private volatile boolean shutdown;

    IOBalancerThread(IOBalancer ioBalancer, int balancerIntervalSeconds, HazelcastThreadGroup threadGroup, ILogger log) {
        super(threadGroup.getInternalThreadGroup(), threadGroup.getThreadNamePrefix(THREAD_NAME_PREFIX));
        this.ioBalancer = ioBalancer;
        this.log = log;
        this.balancerIntervalSeconds = balancerIntervalSeconds;
    }

    void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    @Override
    public void run() {
        try {
            this.log.finest("Starting IOBalancer thread");
            while (!this.shutdown) {
                this.ioBalancer.checkReadHandlers();
                this.ioBalancer.checkWriteHandlers();
                TimeUnit.SECONDS.sleep(this.balancerIntervalSeconds);
            }
        }
        catch (InterruptedException e) {
            this.log.finest("IOBalancer thread stopped");
            EmptyStatement.ignore(e);
        }
        catch (Throwable e) {
            this.log.severe("IOBalancer failed", e);
        }
    }
}

