/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.nio.tcp.spinning;

import com.att.aft.dme2.hazelcast.instance.HazelcastThreadGroup;
import com.att.aft.dme2.hazelcast.internal.metrics.MetricsRegistry;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.logging.LoggingService;
import com.att.aft.dme2.hazelcast.nio.IOService;
import com.att.aft.dme2.hazelcast.nio.tcp.IOThreadingModel;
import com.att.aft.dme2.hazelcast.nio.tcp.SocketReader;
import com.att.aft.dme2.hazelcast.nio.tcp.SocketWriter;
import com.att.aft.dme2.hazelcast.nio.tcp.TcpIpConnection;
import com.att.aft.dme2.hazelcast.nio.tcp.spinning.SpinningInputThread;
import com.att.aft.dme2.hazelcast.nio.tcp.spinning.SpinningOutputThread;
import com.att.aft.dme2.hazelcast.nio.tcp.spinning.SpinningSocketReader;
import com.att.aft.dme2.hazelcast.nio.tcp.spinning.SpinningSocketWriter;

public class SpinningIOThreadingModel
implements IOThreadingModel {
    private final ILogger logger;
    private final MetricsRegistry metricsRegistry;
    private final LoggingService loggingService;
    private final SpinningInputThread inputThread;
    private final SpinningOutputThread outThread;

    public SpinningIOThreadingModel(IOService ioService, LoggingService loggingService, MetricsRegistry metricsRegistry, HazelcastThreadGroup hazelcastThreadGroup) {
        this.logger = loggingService.getLogger(SpinningIOThreadingModel.class);
        this.metricsRegistry = metricsRegistry;
        this.loggingService = loggingService;
        this.inputThread = new SpinningInputThread(hazelcastThreadGroup, loggingService.getLogger(SpinningInputThread.class));
        this.outThread = new SpinningOutputThread(hazelcastThreadGroup, loggingService.getLogger(SpinningOutputThread.class));
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public SocketWriter newSocketWriter(TcpIpConnection connection) {
        ILogger logger = this.loggingService.getLogger(SpinningSocketWriter.class);
        return new SpinningSocketWriter(connection, this.metricsRegistry, logger);
    }

    @Override
    public SocketReader newSocketReader(TcpIpConnection connection) {
        ILogger logger = this.loggingService.getLogger(SpinningSocketReader.class);
        return new SpinningSocketReader(connection, this.metricsRegistry, logger);
    }

    @Override
    public void onConnectionAdded(TcpIpConnection connection) {
        this.inputThread.addConnection(connection);
        this.outThread.addConnection(connection);
    }

    @Override
    public void onConnectionRemoved(TcpIpConnection connection) {
        this.inputThread.removeConnection(connection);
        this.outThread.removeConnection(connection);
    }

    @Override
    public void start() {
        this.logger.info("TcpIpConnectionManager configured with Spinning IO-threading model: 1 input thread and 1 output thread");
        this.inputThread.start();
        this.outThread.start();
    }

    @Override
    public void shutdown() {
        this.inputThread.shutdown();
        this.outThread.shutdown();
    }
}

