/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.partition.membergroup;

import com.att.aft.dme2.hazelcast.config.PartitionGroupConfig;
import com.att.aft.dme2.hazelcast.partition.membergroup.ConfigMemberGroupFactory;
import com.att.aft.dme2.hazelcast.partition.membergroup.HostAwareMemberGroupFactory;
import com.att.aft.dme2.hazelcast.partition.membergroup.MemberGroupFactory;
import com.att.aft.dme2.hazelcast.partition.membergroup.SPIAwareMemberGroupFactory;
import com.att.aft.dme2.hazelcast.partition.membergroup.SingleMemberGroupFactory;
import com.att.aft.dme2.hazelcast.partition.membergroup.ZoneAwareMemberGroupFactory;
import com.att.aft.dme2.hazelcast.spi.discovery.integration.DiscoveryService;

public final class MemberGroupFactoryFactory {
    private MemberGroupFactoryFactory() {
    }

    public static MemberGroupFactory newMemberGroupFactory(PartitionGroupConfig partitionGroupConfig, DiscoveryService discoveryService) {
        PartitionGroupConfig.MemberGroupType memberGroupType = partitionGroupConfig == null || !partitionGroupConfig.isEnabled() ? PartitionGroupConfig.MemberGroupType.PER_MEMBER : partitionGroupConfig.getGroupType();
        switch (memberGroupType) {
            case HOST_AWARE: {
                return new HostAwareMemberGroupFactory();
            }
            case CUSTOM: {
                return new ConfigMemberGroupFactory(partitionGroupConfig.getMemberGroupConfigs());
            }
            case PER_MEMBER: {
                return new SingleMemberGroupFactory();
            }
            case ZONE_AWARE: {
                return new ZoneAwareMemberGroupFactory();
            }
            case SPI: {
                return new SPIAwareMemberGroupFactory(discoveryService);
            }
        }
        throw new RuntimeException("Unknown MemberGroupType:" + (Object)((Object)memberGroupType));
    }
}

