/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.partition.membergroup;

import com.att.aft.dme2.hazelcast.config.InvalidConfigurationException;
import com.att.aft.dme2.hazelcast.config.properties.ValidationException;
import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.partition.membergroup.BackupSafeMemberGroupFactory;
import com.att.aft.dme2.hazelcast.partition.membergroup.MemberGroup;
import com.att.aft.dme2.hazelcast.partition.membergroup.MemberGroupFactory;
import com.att.aft.dme2.hazelcast.spi.discovery.DiscoveryStrategy;
import com.att.aft.dme2.hazelcast.spi.discovery.impl.DefaultDiscoveryService;
import com.att.aft.dme2.hazelcast.spi.discovery.integration.DiscoveryService;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SPIAwareMemberGroupFactory
extends BackupSafeMemberGroupFactory
implements MemberGroupFactory {
    private final DiscoveryService discoveryService;

    public SPIAwareMemberGroupFactory(DiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    @Override
    protected Set<MemberGroup> createInternalMemberGroups(Collection<? extends Member> allMembers) {
        HashSet<MemberGroup> memberGroups = new HashSet<MemberGroup>();
        for (Member member : allMembers) {
            try {
                if (!member.localMember()) continue;
                DefaultDiscoveryService defaultDiscoveryService = (DefaultDiscoveryService)this.discoveryService;
                if (!defaultDiscoveryService.getDiscoveryStrategies().iterator().hasNext()) {
                    throw new RuntimeException("Could not load any Discovery Strategy, please check service definitions under META_INF.services folder. ");
                }
                Iterator<DiscoveryStrategy> i$ = defaultDiscoveryService.getDiscoveryStrategies().iterator();
                if (!i$.hasNext()) continue;
                DiscoveryStrategy discoveryStrategy = i$.next();
                Preconditions.checkNotNull(discoveryStrategy.getPartitionGroupStrategy());
                Iterable<MemberGroup> spiGroupsIterator = discoveryStrategy.getPartitionGroupStrategy().getMemberGroups();
                for (MemberGroup group : spiGroupsIterator) {
                    memberGroups.add(group);
                }
                return memberGroups;
            }
            catch (Exception e) {
                if (e instanceof ValidationException) {
                    throw new InvalidConfigurationException("Invalid configuration", e);
                }
                throw new RuntimeException("Failed to configure discovery strategies", e);
            }
        }
        return memberGroups;
    }
}

