/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.query.impl;

import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.query.Predicate;
import com.att.aft.dme2.hazelcast.query.impl.QueryableEntry;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class AndResultSet
extends AbstractSet<QueryableEntry> {
    private final Set<QueryableEntry> setSmallest;
    private final List<Set<QueryableEntry>> otherIndexedResults;
    private final List<Predicate> lsNoIndexPredicates;

    public AndResultSet(Set<QueryableEntry> setSmallest, List<Set<QueryableEntry>> otherIndexedResults, List<Predicate> lsNoIndexPredicates) {
        this.setSmallest = Preconditions.isNotNull(setSmallest, "setSmallest");
        this.otherIndexedResults = otherIndexedResults;
        this.lsNoIndexPredicates = lsNoIndexPredicates;
    }

    public byte[] toByteArray(ObjectDataOutput out) throws IOException {
        for (QueryableEntry entry : this.setSmallest) {
            Iterator<Object> i$;
            if (this.otherIndexedResults != null) {
                Set otherIndexedResult;
                i$ = this.otherIndexedResults.iterator();
                while (i$.hasNext() && (otherIndexedResult = (Set)i$.next()).contains(entry)) {
                }
            }
            if (this.lsNoIndexPredicates != null) {
                Predicate noIndexPredicate;
                i$ = this.lsNoIndexPredicates.iterator();
                while (i$.hasNext() && (noIndexPredicate = (Predicate)i$.next()).apply(entry)) {
                }
            }
            out.writeData(entry.getKeyData());
        }
        return out.toByteArray();
    }

    @Override
    public boolean contains(Object o) {
        if (!this.setSmallest.contains(o)) {
            return false;
        }
        if (this.otherIndexedResults != null) {
            for (Set set : this.otherIndexedResults) {
                if (set.contains(o)) continue;
                return false;
            }
        }
        if (this.lsNoIndexPredicates != null) {
            for (Predicate predicate : this.lsNoIndexPredicates) {
                if (predicate.apply((Map.Entry)o)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<QueryableEntry> iterator() {
        return new It();
    }

    @Override
    public int size() {
        return this.setSmallest.size();
    }

    class It
    implements Iterator<QueryableEntry> {
        QueryableEntry currentEntry;
        final Iterator<QueryableEntry> it;

        It() {
            this.it = AndResultSet.this.setSmallest.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.currentEntry != null) {
                return true;
            }
            while (this.it.hasNext()) {
                QueryableEntry entry = this.it.next();
                if (!this.checkOtherIndexedResults(entry) || !this.checkNoIndexPredicates(entry)) continue;
                this.currentEntry = entry;
                return true;
            }
            return false;
        }

        private boolean checkNoIndexPredicates(QueryableEntry currentEntry) {
            if (AndResultSet.this.lsNoIndexPredicates == null) {
                return true;
            }
            for (Predicate noIndexPredicate : AndResultSet.this.lsNoIndexPredicates) {
                if (noIndexPredicate.apply(currentEntry)) continue;
                return false;
            }
            return true;
        }

        private boolean checkOtherIndexedResults(QueryableEntry currentEntry) {
            if (AndResultSet.this.otherIndexedResults == null) {
                return true;
            }
            for (Set otherIndexedResult : AndResultSet.this.otherIndexedResults) {
                if (otherIndexedResult.contains(currentEntry)) continue;
                return false;
            }
            return true;
        }

        @Override
        public QueryableEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            QueryableEntry result = this.currentEntry;
            this.currentEntry = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

