/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.query.impl;

import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.query.impl.BaseIndexStore;
import com.att.aft.dme2.hazelcast.query.impl.ComparisonType;
import com.att.aft.dme2.hazelcast.query.impl.IndexImpl;
import com.att.aft.dme2.hazelcast.query.impl.MultiResultSet;
import com.att.aft.dme2.hazelcast.query.impl.QueryableEntry;
import com.att.aft.dme2.hazelcast.query.impl.SingleResultSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class SortedIndexStore
extends BaseIndexStore {
    private final ConcurrentMap<Data, QueryableEntry> recordsWithNullValue = new ConcurrentHashMap<Data, QueryableEntry>();
    private final ConcurrentSkipListMap<Comparable, ConcurrentMap<Data, QueryableEntry>> recordMap = new ConcurrentSkipListMap();

    @Override
    void newIndexInternal(Comparable newValue, QueryableEntry record) {
        if (newValue instanceof IndexImpl.NullObject) {
            this.recordsWithNullValue.put(record.getKeyData(), record);
        } else {
            this.mapAttributeToEntry(newValue, record);
        }
    }

    private void mapAttributeToEntry(Comparable attribute, QueryableEntry entry) {
        ConcurrentMap<Data, QueryableEntry> records = this.recordMap.get(attribute);
        if (records == null) {
            records = new ConcurrentHashMap<Data, QueryableEntry>(1, 0.75f, 1);
            this.recordMap.put(attribute, records);
        }
        records.put(entry.getKeyData(), entry);
    }

    @Override
    void removeIndexInternal(Comparable oldValue, Data indexKey) {
        if (oldValue instanceof IndexImpl.NullObject) {
            this.recordsWithNullValue.remove(indexKey);
        } else {
            this.removeMappingForAttribute(oldValue, indexKey);
        }
    }

    private void removeMappingForAttribute(Object attribute, Data indexKey) {
        ConcurrentMap<Data, QueryableEntry> records = this.recordMap.get(attribute);
        if (records != null) {
            records.remove(indexKey);
            if (records.size() == 0) {
                this.recordMap.remove(attribute);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.takeWriteLock();
        try {
            this.recordsWithNullValue.clear();
            this.recordMap.clear();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getSubRecordsBetween(Comparable from, Comparable to) {
        this.takeReadLock();
        try {
            MultiResultSet results = this.createMultiResultSet();
            NavigableMap subMap = this.recordMap.subMap((Object)from, true, (Object)to, true);
            for (ConcurrentMap value : subMap.values()) {
                results.addResultSet(value);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getSubRecords(ComparisonType comparisonType, Comparable searchedValue) {
        this.takeReadLock();
        try {
            NavigableMap subMap;
            MultiResultSet results = this.createMultiResultSet();
            switch (comparisonType) {
                case LESSER: {
                    subMap = this.recordMap.headMap((Object)searchedValue, false);
                    break;
                }
                case LESSER_EQUAL: {
                    subMap = this.recordMap.headMap((Object)searchedValue, true);
                    break;
                }
                case GREATER: {
                    subMap = this.recordMap.tailMap((Object)searchedValue, false);
                    break;
                }
                case GREATER_EQUAL: {
                    subMap = this.recordMap.tailMap((Object)searchedValue, true);
                    break;
                }
                case NOT_EQUAL: {
                    for (Map.Entry<Comparable, ConcurrentMap<Data, QueryableEntry>> entry : this.recordMap.entrySet()) {
                        if (searchedValue.equals(entry.getKey())) continue;
                        results.addResultSet(entry.getValue());
                    }
                    MultiResultSet i$ = results;
                    return i$;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized comparisonType: " + (Object)((Object)comparisonType));
                }
            }
            for (ConcurrentMap value : subMap.values()) {
                results.addResultSet(value);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConcurrentMap<Data, QueryableEntry> getRecordMap(Comparable value) {
        this.takeReadLock();
        try {
            if (value instanceof IndexImpl.NullObject) {
                ConcurrentMap<Data, QueryableEntry> concurrentMap = this.recordsWithNullValue;
                return concurrentMap;
            }
            ConcurrentMap<Data, QueryableEntry> concurrentMap = this.recordMap.get(value);
            return concurrentMap;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getRecords(Comparable value) {
        this.takeReadLock();
        try {
            if (value instanceof IndexImpl.NullObject) {
                SingleResultSet singleResultSet = new SingleResultSet(this.recordsWithNullValue);
                return singleResultSet;
            }
            SingleResultSet singleResultSet = new SingleResultSet(this.recordMap.get(value));
            return singleResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getRecords(Set<Comparable> values) {
        this.takeReadLock();
        try {
            MultiResultSet results = this.createMultiResultSet();
            for (Comparable value : values) {
                ConcurrentMap<Data, QueryableEntry> records = value instanceof IndexImpl.NullObject ? this.recordsWithNullValue : this.recordMap.get(value);
                if (records == null) continue;
                results.addResultSet(records);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public String toString() {
        return "SortedIndexStore{recordMap=" + this.recordMap.size() + '}';
    }
}

