/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.query.impl;

import com.att.aft.dme2.hazelcast.core.TypeConverter;
import com.att.aft.dme2.hazelcast.nio.serialization.Portable;
import com.att.aft.dme2.hazelcast.query.impl.DateHelper;
import com.att.aft.dme2.hazelcast.query.impl.IdentityConverter;
import com.att.aft.dme2.hazelcast.query.impl.IndexImpl;
import com.att.aft.dme2.hazelcast.query.impl.UUIDConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;

public final class TypeConverters {
    public static final TypeConverter BIG_INTEGER_CONVERTER = new BigIntegerConverter();
    public static final TypeConverter BIG_DECIMAL_CONVERTER = new BigDecimalConverter();
    public static final TypeConverter DOUBLE_CONVERTER = new DoubleConverter();
    public static final TypeConverter LONG_CONVERTER = new LongConverter();
    public static final TypeConverter INTEGER_CONVERTER = new IntegerConverter();
    public static final TypeConverter BOOLEAN_CONVERTER = new BooleanConverter();
    public static final TypeConverter SHORT_CONVERTER = new ShortConverter();
    public static final TypeConverter FLOAT_CONVERTER = new FloatConverter();
    public static final TypeConverter STRING_CONVERTER = new StringConverter();
    public static final TypeConverter CHAR_CONVERTER = new CharConverter();
    public static final TypeConverter BYTE_CONVERTER = new ByteConverter();
    public static final TypeConverter ENUM_CONVERTER = new EnumConverter();
    public static final TypeConverter SQL_DATE_CONVERTER = new SqlDateConverter();
    public static final TypeConverter SQL_TIMESTAMP_CONVERTER = new SqlTimestampConverter();
    public static final TypeConverter DATE_CONVERTER = new DateConverter();
    public static final TypeConverter IDENTITY_CONVERTER = new IdentityConverter();
    public static final TypeConverter NULL_CONVERTER = new IdentityConverter();
    public static final TypeConverter UUID_CONVERTER = new UUIDConverter();
    public static final TypeConverter PORTABLE_CONVERTER = new PortableConverter();

    private TypeConverters() {
    }

    static class PortableConverter
    extends BaseTypeConverter {
        PortableConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            if (value instanceof Portable) {
                return value;
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "]");
        }
    }

    static class CharConverter
    extends BaseTypeConverter {
        CharConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            if (value.getClass() == Character.TYPE) {
                return value;
            }
            if (value instanceof Character) {
                return value;
            }
            if (value instanceof String) {
                return Character.valueOf(((String)((Object)value)).charAt(0));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Integer.valueOf(number.intValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to char");
        }
    }

    static class ByteConverter
    extends BaseTypeConverter {
        ByteConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            if (value instanceof Byte) {
                return value;
            }
            if (value instanceof String) {
                return Byte.valueOf(Byte.parseByte((String)((Object)value)));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Byte.valueOf(number.byteValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to byte");
        }
    }

    static class BooleanConverter
    extends BaseTypeConverter {
        BooleanConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof String) {
                return Boolean.valueOf(Boolean.parseBoolean((String)((Object)value)));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Boolean.valueOf(number.intValue() != 0);
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to boolean");
        }
    }

    static class ShortConverter
    extends BaseTypeConverter {
        ShortConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            if (value instanceof Short) {
                return value;
            }
            if (value instanceof String) {
                return Short.valueOf(Short.parseShort((String)((Object)value)));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Short.valueOf(number.shortValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to short");
        }
    }

    static class FloatConverter
    extends BaseTypeConverter {
        FloatConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            if (value instanceof Float) {
                return value;
            }
            if (value instanceof String) {
                return Float.valueOf(Float.parseFloat((String)((Object)value)));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Float.valueOf(number.floatValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to float");
        }
    }

    static class StringConverter
    extends BaseTypeConverter {
        StringConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            if (value instanceof String) {
                return value;
            }
            return value.toString();
        }
    }

    static class IntegerConverter
    extends BaseTypeConverter {
        IntegerConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            if (value instanceof Integer) {
                return value;
            }
            if (value instanceof String) {
                return Integer.valueOf(Integer.parseInt((String)((Object)value)));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Integer.valueOf(number.intValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to integer");
        }
    }

    static class BigDecimalConverter
    extends BaseTypeConverter {
        BigDecimalConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            if (value instanceof BigDecimal) {
                return value;
            }
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            if (this.isIntegralDataType(value)) {
                Number number = (Number)((Object)value);
                return BigDecimal.valueOf(number.longValue());
            }
            if (this.isFloatingPointDataType(value)) {
                Number number = (Number)((Object)value);
                return new BigDecimal(number.doubleValue());
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            return new BigDecimal(value.toString());
        }

        private boolean isFloatingPointDataType(Comparable value) {
            return value instanceof Double || value instanceof Float;
        }

        private boolean isIntegralDataType(Comparable value) {
            return value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long;
        }
    }

    static class BigIntegerConverter
    extends BaseTypeConverter {
        BigIntegerConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            if (value instanceof BigInteger) {
                return value;
            }
            if (value instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)value;
                return decimal.toBigInteger();
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return BigInteger.valueOf(number.longValue());
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
            }
            return new BigInteger(value.toString());
        }
    }

    static class LongConverter
    extends BaseTypeConverter {
        LongConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            if (value instanceof Long) {
                return value;
            }
            if (value instanceof String) {
                return Long.valueOf(Long.parseLong((String)((Object)value)));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Long.valueOf(number.longValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to long");
        }
    }

    static class DoubleConverter
    extends BaseTypeConverter {
        DoubleConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            if (value instanceof Double) {
                return value;
            }
            if (value instanceof String) {
                return Double.valueOf(Double.parseDouble((String)((Object)value)));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Double.valueOf(number.doubleValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to double");
        }
    }

    static class DateConverter
    extends BaseTypeConverter {
        DateConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            if (value instanceof java.util.Date) {
                return value;
            }
            if (value instanceof String) {
                return DateHelper.parseDate((String)((Object)value));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return new java.util.Date(number.longValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to java.util.Date");
        }
    }

    static class SqlTimestampConverter
    extends BaseTypeConverter {
        SqlTimestampConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            if (value instanceof Timestamp) {
                return value;
            }
            if (value instanceof java.util.Date) {
                return new Timestamp(((java.util.Date)value).getTime());
            }
            if (value instanceof String) {
                return DateHelper.parseTimeStamp((String)((Object)value));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return new Timestamp(number.longValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to java.sql.Timestamp");
        }
    }

    static class SqlDateConverter
    extends BaseTypeConverter {
        SqlDateConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            if (value instanceof java.util.Date) {
                return value;
            }
            if (value instanceof String) {
                return DateHelper.parseSqlDate((String)((Object)value));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return new Date(number.longValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to java.sql.Date");
        }
    }

    static class EnumConverter
    extends BaseTypeConverter {
        EnumConverter() {
        }

        @Override
        Comparable convertInternal(Comparable value) {
            String enumString = value.toString();
            if (enumString.contains(".")) {
                enumString = enumString.substring(1 + enumString.lastIndexOf(46));
            }
            return enumString;
        }
    }

    public static abstract class BaseTypeConverter
    implements TypeConverter {
        abstract Comparable convertInternal(Comparable var1);

        @Override
        public final Comparable convert(Comparable value) {
            if (value == null) {
                return IndexImpl.NULL;
            }
            return this.convertInternal(value);
        }
    }
}

