/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.query.impl.getters;

import com.att.aft.dme2.hazelcast.config.MapAttributeConfig;
import com.att.aft.dme2.hazelcast.internal.serialization.InternalSerializationService;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.Portable;
import com.att.aft.dme2.hazelcast.query.QueryException;
import com.att.aft.dme2.hazelcast.query.extractor.ValueExtractor;
import com.att.aft.dme2.hazelcast.query.impl.DefaultArgumentParser;
import com.att.aft.dme2.hazelcast.query.impl.getters.EvictableGetterCache;
import com.att.aft.dme2.hazelcast.query.impl.getters.ExtractorGetter;
import com.att.aft.dme2.hazelcast.query.impl.getters.ExtractorHelper;
import com.att.aft.dme2.hazelcast.query.impl.getters.Getter;
import com.att.aft.dme2.hazelcast.query.impl.getters.PortableGetter;
import com.att.aft.dme2.hazelcast.query.impl.getters.ReflectionHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Extractors {
    private static final int MAX_CLASSES_IN_CACHE = 1000;
    private static final int MAX_GETTERS_PER_CLASS_IN_CACHE = 100;
    private static final float EVICTION_PERCENTAGE = 0.2f;
    private volatile PortableGetter genericPortableGetter;
    private final Map<String, ValueExtractor> extractors;
    private final EvictableGetterCache getterCache;
    private final DefaultArgumentParser argumentsParser;

    public Extractors(List<MapAttributeConfig> mapAttributeConfigs, ClassLoader classLoader) {
        this.extractors = ExtractorHelper.instantiateExtractors(mapAttributeConfigs, classLoader);
        this.getterCache = new EvictableGetterCache(1000, 100, 0.2f);
        this.argumentsParser = new DefaultArgumentParser();
    }

    public Object extract(InternalSerializationService serializationService, Object target, String attributeName) {
        Object targetObject = Extractors.getTargetObject(serializationService, target);
        if (targetObject != null) {
            Getter getter = this.getGetter(serializationService, targetObject, attributeName);
            try {
                return getter.getValue(targetObject, attributeName);
            }
            catch (Exception ex) {
                throw new QueryException(ex);
            }
        }
        return null;
    }

    private static Object getTargetObject(InternalSerializationService serializationService, Object target) {
        Object targetData;
        if (target instanceof Portable && (targetData = serializationService.toData(target)).isPortable()) {
            return targetData;
        }
        if (target instanceof Data) {
            targetData = (Data)target;
            if (targetData.isPortable()) {
                return targetData;
            }
            return serializationService.toObject(target);
        }
        return target;
    }

    Getter getGetter(InternalSerializationService serializationService, Object targetObject, String attributeName) {
        Getter getter = this.getterCache.getGetter(targetObject.getClass(), attributeName);
        if (getter == null && (getter = this.instantiateGetter(serializationService, targetObject, attributeName)).isCacheable()) {
            this.getterCache.putGetter(targetObject.getClass(), attributeName, getter);
        }
        return getter;
    }

    private Getter instantiateGetter(InternalSerializationService serializationService, Object targetObject, String attributeName) {
        String attributeNameWithoutArguments = ExtractorHelper.extractAttributeNameNameWithoutArguments(attributeName);
        ValueExtractor valueExtractor = this.extractors.get(attributeNameWithoutArguments);
        if (valueExtractor != null) {
            Object arguments = this.argumentsParser.parse(ExtractorHelper.extractArgumentsFromAttributeName(attributeName));
            return new ExtractorGetter(serializationService, valueExtractor, arguments);
        }
        if (targetObject instanceof Data) {
            if (this.genericPortableGetter == null) {
                this.genericPortableGetter = new PortableGetter(serializationService);
            }
            return this.genericPortableGetter;
        }
        return ReflectionHelper.createGetter(targetObject, attributeName);
    }

    public static Extractors empty() {
        return new Extractors(Collections.<MapAttributeConfig>emptyList(), null);
    }
}

