/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.query.impl.getters;

import com.att.aft.dme2.hazelcast.internal.serialization.InternalSerializationService;
import com.att.aft.dme2.hazelcast.internal.serialization.PortableContext;
import com.att.aft.dme2.hazelcast.internal.serialization.impl.DefaultPortableReader;
import com.att.aft.dme2.hazelcast.nio.serialization.ClassDefinition;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.FieldDefinition;
import com.att.aft.dme2.hazelcast.nio.serialization.PortableReader;
import com.att.aft.dme2.hazelcast.query.impl.getters.Getter;

final class PortableGetter
extends Getter {
    private final InternalSerializationService serializationService;

    public PortableGetter(InternalSerializationService serializationService) {
        super(null);
        this.serializationService = serializationService;
    }

    @Override
    Object getValue(Object target, String fieldPath) throws Exception {
        Data data = (Data)target;
        PortableContext context = this.serializationService.getPortableContext();
        PortableReader reader = this.serializationService.createPortableReader(data);
        ClassDefinition classDefinition = context.lookupClassDefinition(data);
        FieldDefinition fieldDefinition = context.getFieldDefinition(classDefinition, fieldPath);
        if (fieldDefinition != null) {
            return ((DefaultPortableReader)reader).read(fieldPath);
        }
        return null;
    }

    @Override
    Object getValue(Object obj) throws Exception {
        throw new IllegalArgumentException("Path agnostic value extraction unsupported");
    }

    @Override
    Class getReturnType() {
        throw new IllegalArgumentException("Non applicable for PortableGetter");
    }

    @Override
    boolean isCacheable() {
        return false;
    }
}

