/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.query.impl.predicates;

import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.query.impl.Index;
import com.att.aft.dme2.hazelcast.query.impl.QueryContext;
import com.att.aft.dme2.hazelcast.query.impl.QueryableEntry;
import com.att.aft.dme2.hazelcast.query.impl.predicates.AbstractIndexAwarePredicate;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class BetweenPredicate
extends AbstractIndexAwarePredicate {
    Comparable to;
    Comparable from;

    public BetweenPredicate() {
    }

    public BetweenPredicate(String first, Comparable from, Comparable to) {
        super(first);
        if (from == null || to == null) {
            throw new NullPointerException("Arguments can't be null");
        }
        this.from = from;
        this.to = to;
    }

    @Override
    protected boolean applyForSingleAttributeValue(Map.Entry entry, Comparable attributeValue) {
        if (attributeValue == null) {
            return false;
        }
        Comparable fromConvertedValue = this.convert(entry, attributeValue, this.from);
        Comparable toConvertedValue = this.convert(entry, attributeValue, this.to);
        if (fromConvertedValue == null || toConvertedValue == null) {
            return false;
        }
        return attributeValue.compareTo(fromConvertedValue) >= 0 && attributeValue.compareTo(toConvertedValue) <= 0;
    }

    @Override
    public Set<QueryableEntry> filter(QueryContext queryContext) {
        Index index = this.getIndex(queryContext);
        return index.getSubRecordsBetween(this.from, this.to);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject(this.to);
        out.writeObject(this.from);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.to = (Comparable)in.readObject();
        this.from = (Comparable)in.readObject();
    }

    public String toString() {
        return this.attributeName + " BETWEEN " + this.from + " AND " + this.to;
    }

    @Override
    public int getId() {
        return 2;
    }
}

