/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.query.impl.predicates;

import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.query.Predicate;
import com.att.aft.dme2.hazelcast.query.impl.Index;
import com.att.aft.dme2.hazelcast.query.impl.IndexImpl;
import com.att.aft.dme2.hazelcast.query.impl.QueryContext;
import com.att.aft.dme2.hazelcast.query.impl.QueryableEntry;
import com.att.aft.dme2.hazelcast.query.impl.predicates.AbstractIndexAwarePredicate;
import com.att.aft.dme2.hazelcast.query.impl.predicates.NegatablePredicate;
import com.att.aft.dme2.hazelcast.query.impl.predicates.NotEqualPredicate;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class EqualPredicate
extends AbstractIndexAwarePredicate
implements NegatablePredicate {
    protected Comparable value;

    public EqualPredicate() {
    }

    public EqualPredicate(String attribute) {
        super(attribute);
    }

    public EqualPredicate(String attribute, Comparable value) {
        super(attribute);
        this.value = value;
    }

    @Override
    public Set<QueryableEntry> filter(QueryContext queryContext) {
        Index index = this.getIndex(queryContext);
        return index.getRecords(this.value);
    }

    @Override
    protected boolean applyForSingleAttributeValue(Map.Entry mapEntry, Comparable attributeValue) {
        if (attributeValue == null) {
            return this.value == null || this.value == IndexImpl.NULL;
        }
        this.value = this.convert(mapEntry, attributeValue, this.value);
        return attributeValue.equals(this.value);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject(this.value);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.value = (Comparable)in.readObject();
    }

    public String toString() {
        return this.attributeName + "=" + this.value;
    }

    @Override
    public Predicate negate() {
        return new NotEqualPredicate(this.attributeName, this.value);
    }

    @Override
    public int getId() {
        return 3;
    }
}

