/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.query.impl.predicates;

import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.query.impl.predicates.AbstractPredicate;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LikePredicate
extends AbstractPredicate {
    protected String expression;
    private volatile Pattern pattern;

    public LikePredicate() {
    }

    public LikePredicate(String attributeName, String expression) {
        this.attributeName = attributeName;
        this.expression = expression;
    }

    @Override
    protected boolean applyForSingleAttributeValue(Map.Entry mapEntry, Comparable attributeValue) {
        String attributeValueString = (String)((Object)attributeValue);
        if (attributeValueString == null) {
            return this.expression == null;
        }
        if (this.expression == null) {
            return false;
        }
        if (this.pattern == null) {
            String quotedExpression = Pattern.quote(this.expression);
            String regex = quotedExpression.replaceAll("(?<!\\\\)[%]", "\\\\E.*\\\\Q").replaceAll("(?<!\\\\)[_]", "\\\\E.\\\\Q").replaceAll("\\\\%", "%").replaceAll("\\\\_", "_");
            int flags = this.getFlags();
            this.pattern = Pattern.compile(regex, flags);
        }
        Matcher m = this.pattern.matcher(attributeValueString);
        return m.matches();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.attributeName);
        out.writeUTF(this.expression);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.attributeName = in.readUTF();
        this.expression = in.readUTF();
    }

    protected int getFlags() {
        return 0;
    }

    public String toString() {
        return this.attributeName + " LIKE '" + this.expression + "'";
    }

    @Override
    public int getId() {
        return 5;
    }
}

