/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.quorum.impl;

import com.att.aft.dme2.hazelcast.cluster.memberselector.MemberSelectors;
import com.att.aft.dme2.hazelcast.config.QuorumConfig;
import com.att.aft.dme2.hazelcast.config.QuorumListenerConfig;
import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.core.MembershipEvent;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.MemberSelectingCollection;
import com.att.aft.dme2.hazelcast.nio.ClassLoaderUtil;
import com.att.aft.dme2.hazelcast.quorum.Quorum;
import com.att.aft.dme2.hazelcast.quorum.QuorumEvent;
import com.att.aft.dme2.hazelcast.quorum.QuorumListener;
import com.att.aft.dme2.hazelcast.quorum.QuorumService;
import com.att.aft.dme2.hazelcast.quorum.impl.QuorumImpl;
import com.att.aft.dme2.hazelcast.spi.EventPublishingService;
import com.att.aft.dme2.hazelcast.spi.EventService;
import com.att.aft.dme2.hazelcast.spi.MemberAttributeServiceEvent;
import com.att.aft.dme2.hazelcast.spi.MembershipAwareService;
import com.att.aft.dme2.hazelcast.spi.MembershipServiceEvent;
import com.att.aft.dme2.hazelcast.spi.NamedOperation;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.QuorumAwareService;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;
import com.att.aft.dme2.hazelcast.util.ExceptionUtil;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class QuorumServiceImpl
implements EventPublishingService<QuorumEvent, QuorumListener>,
MembershipAwareService,
QuorumService {
    public static final String SERVICE_NAME = "hz:impl:quorumService";
    private final NodeEngineImpl nodeEngine;
    private final EventService eventService;
    private boolean inactive;
    private final Map<String, QuorumImpl> quorums = new HashMap<String, QuorumImpl>();

    public QuorumServiceImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.eventService = nodeEngine.getEventService();
        this.initializeQuorums();
        this.inactive = this.quorums.isEmpty();
    }

    public void start() {
        this.initializeListeners();
    }

    private void initializeQuorums() {
        for (QuorumConfig quorumConfig : this.nodeEngine.getConfig().getQuorumConfigs().values()) {
            QuorumImpl quorum = new QuorumImpl(quorumConfig, this.nodeEngine);
            this.quorums.put(quorumConfig.getName(), quorum);
        }
    }

    private void initializeListeners() {
        for (Map.Entry<String, QuorumConfig> configEntry : this.nodeEngine.getConfig().getQuorumConfigs().entrySet()) {
            QuorumConfig config = configEntry.getValue();
            String instanceName = configEntry.getKey();
            for (QuorumListenerConfig listenerConfig : config.getListenerConfigs()) {
                this.initializeListenerInternal(instanceName, listenerConfig);
            }
        }
    }

    private void initializeListenerInternal(String instanceName, QuorumListenerConfig listenerConfig) {
        QuorumListener listener = null;
        if (listenerConfig.getImplementation() != null) {
            listener = listenerConfig.getImplementation();
        } else if (listenerConfig.getClassName() != null) {
            try {
                listener = (QuorumListener)ClassLoaderUtil.newInstance(this.nodeEngine.getConfigClassLoader(), listenerConfig.getClassName());
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        if (listener != null) {
            this.addQuorumListener(instanceName, listener);
        }
    }

    public void addQuorumListener(String name, QuorumListener listener) {
        this.eventService.registerLocalListener(SERVICE_NAME, name, listener);
    }

    public void ensureQuorumPresent(Operation op) {
        if (this.inactive) {
            return;
        }
        QuorumImpl quorum = this.findQuorum(op);
        if (quorum == null) {
            return;
        }
        quorum.ensureQuorumPresent(op);
    }

    private QuorumImpl findQuorum(Operation op) {
        String name;
        if (!this.isNamedOperation(op) || !this.isQuorumAware(op)) {
            return null;
        }
        QuorumAwareService service = (QuorumAwareService)op.getService();
        String quorumName = service.getQuorumName(name = ((NamedOperation)((Object)op)).getName());
        if (quorumName == null) {
            return null;
        }
        return this.quorums.get(quorumName);
    }

    private boolean isQuorumAware(Operation op) {
        return op.getService() instanceof QuorumAwareService;
    }

    private boolean isNamedOperation(Operation op) {
        return op instanceof NamedOperation;
    }

    @Override
    public void dispatchEvent(QuorumEvent event, QuorumListener listener) {
        listener.onChange(event);
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
        this.updateQuorums(event);
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        this.updateQuorums(event);
    }

    @Override
    public void memberAttributeChanged(MemberAttributeServiceEvent event) {
    }

    private void updateQuorums(MembershipEvent event) {
        MemberSelectingCollection<Member> members = new MemberSelectingCollection<Member>(event.getMembers(), MemberSelectors.DATA_MEMBER_SELECTOR);
        for (QuorumImpl quorum : this.quorums.values()) {
            quorum.update(members);
        }
    }

    @Override
    public Quorum getQuorum(String quorumName) {
        Preconditions.checkNotNull(quorumName, "quorumName cannot be null!");
        Quorum quorum = this.quorums.get(quorumName);
        if (quorum == null) {
            throw new IllegalArgumentException("No quorum configuration named [ " + quorumName + " ] is found!");
        }
        return quorum;
    }
}

