/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.replicatedmap.impl;

import com.att.aft.dme2.hazelcast.cluster.memberselector.MemberSelectors;
import com.att.aft.dme2.hazelcast.config.Config;
import com.att.aft.dme2.hazelcast.config.InMemoryFormat;
import com.att.aft.dme2.hazelcast.config.ListenerConfig;
import com.att.aft.dme2.hazelcast.config.ReplicatedMapConfig;
import com.att.aft.dme2.hazelcast.core.DistributedObject;
import com.att.aft.dme2.hazelcast.core.EntryListener;
import com.att.aft.dme2.hazelcast.core.HazelcastInstanceAware;
import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.core.MemberSelector;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.att.aft.dme2.hazelcast.internal.partition.InternalPartition;
import com.att.aft.dme2.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.att.aft.dme2.hazelcast.internal.serialization.impl.HeapData;
import com.att.aft.dme2.hazelcast.monitor.LocalReplicatedMapStats;
import com.att.aft.dme2.hazelcast.monitor.impl.LocalReplicatedMapStatsImpl;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ClassLoaderUtil;
import com.att.aft.dme2.hazelcast.replicatedmap.ReplicatedMapCantBeCreatedOnLiteMemberException;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.PartitionContainer;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.ReplicatedMapEventPublishingService;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.ReplicatedMapProxy;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.ReplicatedMapSplitBrainHandlerService;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.CheckReplicaVersion;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.ReplicationOperation;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.record.ReplicatedRecord;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.att.aft.dme2.hazelcast.replicatedmap.merge.MergePolicyProvider;
import com.att.aft.dme2.hazelcast.spi.EventPublishingService;
import com.att.aft.dme2.hazelcast.spi.ManagedService;
import com.att.aft.dme2.hazelcast.spi.MigrationAwareService;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.PartitionMigrationEvent;
import com.att.aft.dme2.hazelcast.spi.PartitionReplicationEvent;
import com.att.aft.dme2.hazelcast.spi.RemoteService;
import com.att.aft.dme2.hazelcast.spi.SplitBrainHandlerService;
import com.att.aft.dme2.hazelcast.spi.StatisticsAwareService;
import com.att.aft.dme2.hazelcast.spi.impl.eventservice.impl.TrueEventFilter;
import com.att.aft.dme2.hazelcast.util.ConcurrencyUtil;
import com.att.aft.dme2.hazelcast.util.ConstructorFunction;
import com.att.aft.dme2.hazelcast.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class ReplicatedMapService
implements ManagedService,
RemoteService,
EventPublishingService<Object, Object>,
MigrationAwareService,
SplitBrainHandlerService,
StatisticsAwareService {
    public static final String SERVICE_NAME = "hz:impl:replicatedMapService";
    public static final int INVOCATION_TRY_COUNT = 3;
    private static final int SYNC_INTERVAL_SECONDS = 30;
    private final Config config;
    private final NodeEngine nodeEngine;
    private final PartitionContainer[] partitionContainers;
    private final InternalPartitionServiceImpl partitionService;
    private final ClusterServiceImpl clusterService;
    private final OperationService operationService;
    private final ReplicatedMapEventPublishingService eventPublishingService;
    private final MergePolicyProvider mergePolicyProvider;
    private final ReplicatedMapSplitBrainHandlerService replicatedMapSplitBrainHandlerService;
    private ConcurrentHashMap<String, LocalReplicatedMapStatsImpl> statsMap = new ConcurrentHashMap();
    private ConstructorFunction<String, LocalReplicatedMapStatsImpl> constructorFunction = new ConstructorFunction<String, LocalReplicatedMapStatsImpl>(){

        @Override
        public LocalReplicatedMapStatsImpl createNew(String arg) {
            return new LocalReplicatedMapStatsImpl();
        }
    };

    public ReplicatedMapService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.config = nodeEngine.getConfig();
        this.partitionService = (InternalPartitionServiceImpl)nodeEngine.getPartitionService();
        this.clusterService = (ClusterServiceImpl)nodeEngine.getClusterService();
        this.operationService = nodeEngine.getOperationService();
        this.partitionContainers = new PartitionContainer[nodeEngine.getPartitionService().getPartitionCount()];
        this.eventPublishingService = new ReplicatedMapEventPublishingService(this);
        this.mergePolicyProvider = new MergePolicyProvider(nodeEngine);
        this.replicatedMapSplitBrainHandlerService = new ReplicatedMapSplitBrainHandlerService(this, this.mergePolicyProvider);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        if (this.config.isLiteMember()) {
            return;
        }
        for (int i = 0; i < nodeEngine.getPartitionService().getPartitionCount(); ++i) {
            this.partitionContainers[i] = new PartitionContainer(this, i);
        }
        nodeEngine.getExecutionService().getGlobalTaskScheduler().scheduleWithRepetition(new Runnable(){

            @Override
            public void run() {
                ReplicatedMapService.this.triggerAntiEntropy();
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    public void triggerAntiEntropy() {
        if (this.clusterService.getSize(MemberSelectors.DATA_MEMBER_SELECTOR) == 1) {
            return;
        }
        ArrayList<Address> addresses = new ArrayList<Address>(this.getMemberAddresses(MemberSelectors.DATA_MEMBER_SELECTOR));
        addresses.remove(this.nodeEngine.getThisAddress());
        for (int i = 0; i < this.partitionContainers.length; ++i) {
            PartitionContainer partitionContainer;
            InternalPartition partition;
            Address ownerAddress;
            Address thisAddress = this.nodeEngine.getThisAddress();
            if (!thisAddress.equals(ownerAddress = (partition = this.partitionService.getPartition(i, false)).getOwnerOrNull()) || (partitionContainer = this.partitionContainers[i]).isEmpty()) continue;
            for (Address address : addresses) {
                CheckReplicaVersion checkReplicaVersion = new CheckReplicaVersion(partitionContainer);
                checkReplicaVersion.setPartitionId(i);
                checkReplicaVersion.setValidateTarget(false);
                this.operationService.createInvocationBuilder(SERVICE_NAME, (Operation)checkReplicaVersion, address).setTryCount(3).invoke();
            }
        }
    }

    @Override
    public void reset() {
        if (this.config.isLiteMember()) {
            return;
        }
        for (int i = 0; i < this.nodeEngine.getPartitionService().getPartitionCount(); ++i) {
            ConcurrentMap<String, ReplicatedRecordStore> stores = this.partitionContainers[i].getStores();
            for (ReplicatedRecordStore store : stores.values()) {
                store.reset();
            }
        }
    }

    @Override
    public void shutdown(boolean terminate) {
        if (this.config.isLiteMember()) {
            return;
        }
        for (PartitionContainer container : this.partitionContainers) {
            container.shutdown();
        }
    }

    public LocalReplicatedMapStatsImpl getLocalMapStatsImpl(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.constructorFunction);
    }

    public LocalReplicatedMapStatsImpl createReplicatedMapStats(String name) {
        LocalReplicatedMapStatsImpl stats = this.getLocalMapStatsImpl(name);
        long hits = 0L;
        long count = 0L;
        long memoryUsage = 0L;
        boolean isBinary = this.getReplicatedMapConfig(name).getInMemoryFormat() == InMemoryFormat.BINARY;
        for (PartitionContainer container : this.partitionContainers) {
            ReplicatedRecordStore store = container.getRecordStore(name);
            if (store == null) continue;
            Iterator<ReplicatedRecord> iterator = store.recordIterator();
            while (iterator.hasNext()) {
                ReplicatedRecord record = iterator.next();
                stats.setLastAccessTime(Math.max(stats.getLastAccessTime(), record.getLastAccessTime()));
                stats.setLastUpdateTime(Math.max(stats.getLastUpdateTime(), record.getUpdateTime()));
                hits += record.getHits();
                if (isBinary) {
                    memoryUsage += (long)((HeapData)record.getValueInternal()).getHeapCost();
                }
                ++count;
            }
        }
        stats.setOwnedEntryCount(count);
        stats.setHits(hits);
        stats.setOwnedEntryMemoryCost(memoryUsage);
        return stats;
    }

    @Override
    public DistributedObject createDistributedObject(String objectName) {
        if (this.config.isLiteMember()) {
            throw new ReplicatedMapCantBeCreatedOnLiteMemberException(this.nodeEngine.getThisAddress());
        }
        for (int i = 0; i < this.nodeEngine.getPartitionService().getPartitionCount(); ++i) {
            PartitionContainer partitionContainer = this.partitionContainers[i];
            if (partitionContainer == null) continue;
            partitionContainer.getOrCreateRecordStore(objectName);
        }
        return new ReplicatedMapProxy(this.nodeEngine, objectName, this);
    }

    @Override
    public void destroyDistributedObject(String objectName) {
        if (this.config.isLiteMember()) {
            return;
        }
        for (int i = 0; i < this.nodeEngine.getPartitionService().getPartitionCount(); ++i) {
            this.partitionContainers[i].destroy(objectName);
        }
    }

    @Override
    public void dispatchEvent(Object event, Object listener) {
        this.eventPublishingService.dispatchEvent(event, listener);
    }

    public ReplicatedMapConfig getReplicatedMapConfig(String name) {
        return this.config.getReplicatedMapConfig(name).getAsReadOnly();
    }

    public ReplicatedRecordStore getReplicatedRecordStore(String name, boolean create, Object key) {
        return this.getReplicatedRecordStore(name, create, this.partitionService.getPartitionId(key));
    }

    public ReplicatedRecordStore getReplicatedRecordStore(String name, boolean create, int partitionId) {
        if (this.config.isLiteMember()) {
            throw new ReplicatedMapCantBeCreatedOnLiteMemberException(this.nodeEngine.getThisAddress());
        }
        PartitionContainer partitionContainer = this.partitionContainers[partitionId];
        if (create) {
            return partitionContainer.getOrCreateRecordStore(name);
        }
        return partitionContainer.getRecordStore(name);
    }

    public Collection<ReplicatedRecordStore> getAllReplicatedRecordStores(String name) {
        int partitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        ArrayList<ReplicatedRecordStore> stores = new ArrayList<ReplicatedRecordStore>(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            ReplicatedRecordStore recordStore;
            PartitionContainer partitionContainer = this.partitionContainers[i];
            if (partitionContainer == null || (recordStore = partitionContainer.getRecordStore(name)) == null) continue;
            stores.add(recordStore);
        }
        return stores;
    }

    private Collection<Address> getMemberAddresses(MemberSelector memberSelector) {
        Collection<Member> members = this.clusterService.getMembers(memberSelector);
        ArrayList<Address> addresses = new ArrayList<Address>(members.size());
        for (Member member : members) {
            addresses.add(member.getAddress());
        }
        return addresses;
    }

    public void initializeListeners(String name) {
        List<ListenerConfig> listenerConfigs = this.config.getReplicatedMapConfig(name).getListenerConfigs();
        for (ListenerConfig listenerConfig : listenerConfigs) {
            EntryListener listener = null;
            if (listenerConfig.getImplementation() != null) {
                listener = (EntryListener)listenerConfig.getImplementation();
            } else if (listenerConfig.getClassName() != null) {
                try {
                    listener = (EntryListener)ClassLoaderUtil.newInstance(this.nodeEngine.getConfigClassLoader(), listenerConfig.getClassName());
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow(e);
                }
            }
            if (listener == null) continue;
            if (listener instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)((Object)listener)).setHazelcastInstance(this.nodeEngine.getHazelcastInstance());
            }
            this.eventPublishingService.addEventListener(listener, TrueEventFilter.INSTANCE, name);
        }
    }

    public PartitionContainer getPartitionContainer(int partitionId) {
        return this.partitionContainers[partitionId];
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    public ReplicatedMapEventPublishingService getEventPublishingService() {
        return this.eventPublishingService;
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        if (this.config.isLiteMember()) {
            return null;
        }
        if (event.getReplicaIndex() > 0) {
            return null;
        }
        PartitionContainer container = this.partitionContainers[event.getPartitionId()];
        ReplicationOperation operation = new ReplicationOperation(this.nodeEngine.getSerializationService(), container, event.getPartitionId());
        operation.setService(this);
        return operation.isEmpty() ? null : operation;
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
    }

    @Override
    public Runnable prepareMergeRunnable() {
        return this.replicatedMapSplitBrainHandlerService.prepareMergeRunnable();
    }

    public Map<String, LocalReplicatedMapStats> getStats() {
        Collection<String> maps = this.getNodeEngine().getProxyService().getDistributedObjectNames(SERVICE_NAME);
        HashMap<String, LocalReplicatedMapStats> mapStats = new HashMap<String, LocalReplicatedMapStats>(maps.size());
        for (String map : maps) {
            mapStats.put(map, this.createReplicatedMapStats(map));
        }
        return mapStats;
    }
}

