/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.replicatedmap.impl.client;

import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.Portable;
import com.att.aft.dme2.hazelcast.nio.serialization.PortableReader;
import com.att.aft.dme2.hazelcast.nio.serialization.PortableWriter;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.client.ReplicatedMapPortableHook;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class ReplicatedMapValueCollection
implements Portable {
    private Collection<Data> values;

    ReplicatedMapValueCollection() {
    }

    public ReplicatedMapValueCollection(Collection<Data> values) {
        this.values = values;
    }

    public Collection<Data> getValues() {
        return this.values;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("size", this.values.size());
        ObjectDataOutput out = writer.getRawDataOutput();
        for (Data value : this.values) {
            out.writeData(value);
        }
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        int size = reader.readInt("size");
        ObjectDataInput in = reader.getRawDataInput();
        this.values = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            this.values.add(in.readData());
        }
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 14;
    }
}

