/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.replicatedmap.impl.operation;

import com.att.aft.dme2.hazelcast.cluster.memberselector.MemberSelectors;
import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.ReplicateUpdateOperation;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.ReplicateUpdateToCallerOperation;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.VersionResponsePair;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractReplicatedMapOperation
extends AbstractOperation {
    protected String name;
    protected Data key;
    protected Data value;
    protected long ttl;
    protected transient VersionResponsePair response;

    protected void sendReplicationOperation(boolean isRemove) {
        OperationService operationService = this.getNodeEngine().getOperationService();
        Collection<Address> members = this.getMemberAddresses();
        for (Address address : members) {
            this.invoke(isRemove, operationService, address, this.name, this.key, this.value, this.ttl, this.response);
        }
    }

    protected Collection<Address> getMemberAddresses() {
        Address thisAddress = this.getNodeEngine().getThisAddress();
        Collection<Member> members = this.getNodeEngine().getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        ArrayList<Address> addresses = new ArrayList<Address>();
        for (Member member : members) {
            Address address = member.getAddress();
            if (address.equals(this.getCallerAddress()) || address.equals(thisAddress)) continue;
            addresses.add(address);
        }
        return addresses;
    }

    private void invoke(boolean isRemove, OperationService operationService, Address address, String name, Data key, Data value, long ttl, VersionResponsePair response) {
        ReplicateUpdateOperation updateOperation = new ReplicateUpdateOperation(name, key, value, ttl, response, isRemove, this.getCallerAddress());
        updateOperation.setPartitionId(this.getPartitionId());
        updateOperation.setValidateTarget(false);
        operationService.createInvocationBuilder(this.getServiceName(), (Operation)updateOperation, address).setTryCount(3).invoke();
    }

    protected void sendUpdateCallerOperation(boolean isRemove) {
        OperationService operationService = this.getNodeEngine().getOperationService();
        ReplicateUpdateToCallerOperation updateCallerOperation = new ReplicateUpdateToCallerOperation(this.name, this.getCallId(), this.key, this.value, this.response, this.ttl, isRemove);
        updateCallerOperation.setPartitionId(this.getPartitionId());
        updateCallerOperation.setValidateTarget(false);
        updateCallerOperation.setServiceName(this.getServiceName());
        operationService.createInvocationBuilder(this.getServiceName(), (Operation)updateCallerOperation, this.getCallerAddress()).setTryCount(3).invoke();
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        if (this.getNodeEngine().getThisAddress().equals(this.getCallerAddress())) {
            return this.response;
        }
        NormalResponse resp = new NormalResponse(this.response, this.getCallId(), 1, this.isUrgent());
        return resp;
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", name=").append(this.name);
    }
}

