/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.replicatedmap.impl.operation;

import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.PartitionContainer;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.RequestMapDataOperation;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CheckReplicaVersion
extends AbstractOperation
implements PartitionAwareOperation {
    private Map<String, Long> versions;

    public CheckReplicaVersion() {
    }

    public CheckReplicaVersion(PartitionContainer container) {
        this.versions = new ConcurrentHashMap<String, Long>();
        ConcurrentMap<String, ReplicatedRecordStore> stores = container.getStores();
        for (Map.Entry storeEntry : stores.entrySet()) {
            String name = (String)storeEntry.getKey();
            ReplicatedRecordStore store = (ReplicatedRecordStore)storeEntry.getValue();
            long version = store.getVersion();
            this.versions.put(name, version);
        }
    }

    @Override
    public void run() throws Exception {
        ILogger logger = this.getLogger();
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        PartitionContainer container = service.getPartitionContainer(this.getPartitionId());
        ConcurrentMap<String, ReplicatedRecordStore> stores = container.getStores();
        for (Map.Entry<String, Long> entry : this.versions.entrySet()) {
            String name = entry.getKey();
            Long version = entry.getValue();
            ReplicatedRecordStore store = (ReplicatedRecordStore)stores.get(name);
            if (store == null) {
                logger.finest("Missing store on the replica ! Owner version -> " + version);
                this.requestDataFromOwner(name);
                continue;
            }
            if (!store.isStale(version)) continue;
            logger.finest("Stale replica! Owner version ->  " + version + ", Replica version -> " + store.getVersion());
            this.requestDataFromOwner(name);
        }
    }

    private void requestDataFromOwner(String name) {
        OperationService operationService = this.getNodeEngine().getOperationService();
        RequestMapDataOperation requestMapDataOperation = new RequestMapDataOperation(name);
        operationService.createInvocationBuilder("hz:impl:replicatedMapService", (Operation)requestMapDataOperation, this.getPartitionId()).setTryCount(3).invoke();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.versions.size());
        for (Map.Entry<String, Long> entry : this.versions.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeLong(entry.getValue());
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.versions = new ConcurrentHashMap<String, Long>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String name = in.readUTF();
            Long version = in.readLong();
            this.versions.put(name, version);
        }
    }
}

