/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.replicatedmap.impl.operation;

import com.att.aft.dme2.hazelcast.cluster.memberselector.MemberSelectors;
import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.ReplicatedMapEventPublishingService;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.client.ReplicatedMapEntries;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.ReplicateUpdateOperation;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.ReplicatedMapDataSerializerHook;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.VersionResponsePair;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.partition.IPartitionService;
import java.io.IOException;
import java.util.Collection;

public class PutAllOperation
extends AbstractOperation
implements IdentifiedDataSerializable {
    private String name;
    private ReplicatedMapEntries entries;

    public PutAllOperation() {
    }

    public PutAllOperation(String name, ReplicatedMapEntries entries) {
        this.name = name;
        this.entries = entries;
    }

    @Override
    public void run() throws Exception {
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        ReplicatedRecordStore store = service.getReplicatedRecordStore(this.name, true, this.getPartitionId());
        int partitionId = this.getPartitionId();
        IPartitionService partitionService = this.getNodeEngine().getPartitionService();
        ReplicatedMapEventPublishingService eventPublishingService = service.getEventPublishingService();
        for (int i = 0; i < this.entries.size(); ++i) {
            Data key = this.entries.getKey(i);
            Data value = this.entries.getValue(i);
            if (partitionId != partitionService.getPartitionId(key)) continue;
            Object putResult = store.put(key, value);
            Data oldValue = this.getNodeEngine().toData(putResult);
            eventPublishingService.fireEntryListenerEvent(key, oldValue, value, this.name, this.getCallerAddress());
            VersionResponsePair response = new VersionResponsePair(putResult, store.getVersion());
            this.publishReplicationMessage(key, value, response);
        }
    }

    private void publishReplicationMessage(Data key, Data value, VersionResponsePair response) {
        OperationService operationService = this.getNodeEngine().getOperationService();
        Collection<Member> members = this.getNodeEngine().getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        for (Member member : members) {
            Address address = member.getAddress();
            if (address.equals(this.getNodeEngine().getThisAddress())) continue;
            ReplicateUpdateOperation updateOperation = new ReplicateUpdateOperation(this.name, key, value, 0L, response, false, this.getCallerAddress());
            updateOperation.setPartitionId(this.getPartitionId());
            updateOperation.setValidateTarget(false);
            operationService.invokeOnTarget(this.getServiceName(), updateOperation, address);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject(this.entries);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.entries = (ReplicatedMapEntries)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 5;
    }
}

