/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.replicatedmap.impl.operation;

import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.ReplicatedMapEventPublishingService;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.AbstractReplicatedMapOperation;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.ReplicatedMapDataSerializerHook;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.VersionResponsePair;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.att.aft.dme2.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class PutOperation
extends AbstractReplicatedMapOperation
implements PartitionAwareOperation,
IdentifiedDataSerializable {
    private transient ReplicatedMapService service;
    private transient ReplicatedRecordStore store;
    private transient Data oldValue;

    public PutOperation() {
    }

    public PutOperation(String name, Data key, Data value) {
        this.name = name;
        this.key = key;
        this.value = value;
    }

    public PutOperation(String name, Data key, Data value, long ttl) {
        this.name = name;
        this.key = key;
        this.value = value;
        this.ttl = ttl;
    }

    @Override
    public void run() throws Exception {
        this.service = (ReplicatedMapService)this.getService();
        this.store = this.service.getReplicatedRecordStore(this.name, true, this.getPartitionId());
        Address thisAddress = this.getNodeEngine().getThisAddress();
        boolean isLocal = this.getCallerAddress().equals(thisAddress);
        Object putResult = this.store.put(this.key, this.value, this.ttl, TimeUnit.MILLISECONDS, isLocal);
        this.oldValue = this.getNodeEngine().toData(putResult);
        this.response = new VersionResponsePair(putResult, this.store.getVersion());
        if (!isLocal) {
            this.sendUpdateCallerOperation(false);
        }
    }

    @Override
    public void afterRun() throws Exception {
        this.sendReplicationOperation(false);
        ReplicatedMapEventPublishingService eventPublishingService = this.service.getEventPublishingService();
        eventPublishingService.fireEntryListenerEvent(this.key, this.oldValue, this.value, this.name, this.getCallerAddress());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeData(this.key);
        out.writeData(this.value);
        out.writeLong(this.ttl);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.key = in.readData();
        this.value = in.readData();
        this.ttl = in.readLong();
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 6;
    }
}

