/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.replicatedmap.impl.operation;

import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.ReplicatedMapEventPublishingService;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.AbstractReplicatedMapOperation;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.ReplicatedMapDataSerializerHook;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.VersionResponsePair;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.att.aft.dme2.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;

public class RemoveOperation
extends AbstractReplicatedMapOperation
implements PartitionAwareOperation,
IdentifiedDataSerializable {
    private transient ReplicatedMapService service;
    private transient ReplicatedRecordStore store;
    private transient Data oldValue;

    public RemoveOperation() {
    }

    public RemoveOperation(String name, Data key) {
        this.name = name;
        this.key = key;
    }

    @Override
    public void run() throws Exception {
        this.service = (ReplicatedMapService)this.getService();
        this.store = this.service.getReplicatedRecordStore(this.name, true, this.getPartitionId());
        Object removed = this.store.remove(this.key);
        this.oldValue = this.getNodeEngine().toData(removed);
        this.response = new VersionResponsePair(removed, this.store.getVersion());
        Address thisAddress = this.getNodeEngine().getThisAddress();
        if (!this.getCallerAddress().equals(thisAddress)) {
            this.sendUpdateCallerOperation(true);
        }
    }

    @Override
    public void afterRun() throws Exception {
        this.sendReplicationOperation(true);
        ReplicatedMapEventPublishingService eventPublishingService = this.service.getEventPublishingService();
        eventPublishingService.fireEntryListenerEvent(this.key, this.oldValue, null, this.name, this.getCallerAddress());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeData(this.key);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.key = in.readData();
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 7;
    }
}

