/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.replicatedmap.impl.operation;

import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.ReplicatedMapEventPublishingService;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.ReplicatedMapDataSerializerHook;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.VersionResponsePair;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ReplicateUpdateOperation
extends AbstractOperation
implements PartitionAwareOperation,
IdentifiedDataSerializable {
    VersionResponsePair response;
    boolean isRemove;
    String name;
    Data dataKey;
    Data dataValue;
    long ttl;
    Address origin;

    public ReplicateUpdateOperation() {
    }

    public ReplicateUpdateOperation(String name, Data dataKey, Data dataValue, long ttl, VersionResponsePair response, boolean isRemove, Address origin) {
        this.name = name;
        this.dataKey = dataKey;
        this.dataValue = dataValue;
        this.ttl = ttl;
        this.response = response;
        this.isRemove = isRemove;
        this.origin = origin;
    }

    @Override
    public void run() throws Exception {
        long updateVersion;
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        ReplicatedRecordStore store = service.getReplicatedRecordStore(this.name, true, this.getPartitionId());
        long currentVersion = store.getVersion();
        if (currentVersion >= (updateVersion = this.response.getVersion())) {
            this.getLogger().finest("Stale update received for replicated map -> " + this.name + ",  partitionId -> " + this.getPartitionId() + " , current version -> " + currentVersion + ", update version -> " + updateVersion + ", rejecting update!");
            return;
        }
        Object key = store.marshall(this.dataKey);
        Object value = store.marshall(this.dataValue);
        if (this.isRemove) {
            store.removeWithVersion(key, updateVersion);
        } else {
            store.putWithVersion(key, value, this.ttl, TimeUnit.MILLISECONDS, false, updateVersion);
        }
        this.publishEvent();
    }

    private void publishEvent() {
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        ReplicatedMapEventPublishingService eventPublishingService = service.getEventPublishingService();
        Data dataOldValue = this.getNodeEngine().toData(this.response.getResponse());
        if (this.isRemove) {
            eventPublishingService.fireEntryListenerEvent(this.dataKey, dataOldValue, null, this.name, this.origin);
        } else {
            eventPublishingService.fireEntryListenerEvent(this.dataKey, dataOldValue, this.dataValue, this.name, this.origin);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        this.response.writeData(out);
        out.writeUTF(this.name);
        out.writeData(this.dataKey);
        out.writeData(this.dataValue);
        out.writeLong(this.ttl);
        out.writeBoolean(this.isRemove);
        out.writeObject(this.origin);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.response = new VersionResponsePair();
        this.response.readData(in);
        this.name = in.readUTF();
        this.dataKey = in.readData();
        this.dataValue = in.readData();
        this.ttl = in.readLong();
        this.isRemove = in.readBoolean();
        this.origin = (Address)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 3;
    }
}

