/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.replicatedmap.impl.operation;

import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.ReplicatedMapEventPublishingService;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.ReplicatedMapDataSerializerHook;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.VersionResponsePair;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.PartitionAwareOperation;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ReplicateUpdateToCallerOperation
extends AbstractOperation
implements PartitionAwareOperation,
IdentifiedDataSerializable {
    private String name;
    private long callId;
    private Data dataKey;
    private Data dataValue;
    private VersionResponsePair response;
    private long ttl;
    private boolean isRemove;

    public ReplicateUpdateToCallerOperation() {
    }

    public ReplicateUpdateToCallerOperation(String name, long callId, Data dataKey, Data dataValue, VersionResponsePair response, long ttl, boolean isRemove) {
        this.name = name;
        this.callId = callId;
        this.dataKey = dataKey;
        this.dataValue = dataValue;
        this.response = response;
        this.ttl = ttl;
        this.isRemove = isRemove;
    }

    @Override
    public void run() throws Exception {
        long updateVersion;
        ILogger logger = this.getLogger();
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        ReplicatedRecordStore store = service.getReplicatedRecordStore(this.name, true, this.getPartitionId());
        long currentVersion = store.getVersion();
        if (currentVersion >= (updateVersion = this.response.getVersion())) {
            logger.finest("Stale update received for replicated map -> " + this.name + ",  partitionId -> " + this.getPartitionId() + " , current version -> " + currentVersion + ", update version -> " + updateVersion + ", rejecting update!");
            return;
        }
        Object key = store.marshall(this.dataKey);
        Object value = store.marshall(this.dataValue);
        if (this.isRemove) {
            store.removeWithVersion(key, updateVersion);
        } else {
            store.putWithVersion(key, value, this.ttl, TimeUnit.MILLISECONDS, true, updateVersion);
        }
        this.publishEvent();
    }

    @Override
    public void afterRun() throws Exception {
        this.notifyCaller();
    }

    private void publishEvent() {
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        ReplicatedMapEventPublishingService eventPublishingService = service.getEventPublishingService();
        Address thisAddress = this.getNodeEngine().getThisAddress();
        Data dataOldValue = this.getNodeEngine().toData(this.response.getResponse());
        if (this.isRemove) {
            eventPublishingService.fireEntryListenerEvent(this.dataKey, dataOldValue, null, this.name, thisAddress);
        } else {
            eventPublishingService.fireEntryListenerEvent(this.dataKey, dataOldValue, this.dataValue, this.name, thisAddress);
        }
    }

    private void notifyCaller() {
        OperationServiceImpl operationService = (OperationServiceImpl)this.getNodeEngine().getOperationService();
        operationService.getResponseHandler().notifyBackupComplete(this.callId);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.callId);
        out.writeData(this.dataKey);
        out.writeData(this.dataValue);
        this.response.writeData(out);
        out.writeLong(this.ttl);
        out.writeBoolean(this.isRemove);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.callId = in.readLong();
        this.dataKey = in.readData();
        this.dataValue = in.readData();
        this.response = new VersionResponsePair();
        this.response.readData(in);
        this.ttl = in.readLong();
        this.isRemove = in.readBoolean();
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 4;
    }
}

