/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.replicatedmap.impl.operation;

import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.logging.Logger;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.PartitionContainer;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.operation.SyncReplicatedMapDataOperation;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.record.RecordMigrationInfo;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.record.ReplicatedRecord;
import com.att.aft.dme2.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RequestMapDataOperation
extends AbstractOperation {
    private static ILogger logger = Logger.getLogger(RequestMapDataOperation.class.getName());
    String name;

    public RequestMapDataOperation() {
    }

    public RequestMapDataOperation(String name) {
        this.name = name;
    }

    @Override
    public void run() throws Exception {
        logger.finest("Caller { " + this.getCallerAddress() + " } requested copy of map -> " + this.name + ", on partition -> " + this.getPartitionId());
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        PartitionContainer container = service.getPartitionContainer(this.getPartitionId());
        ReplicatedRecordStore store = container.getRecordStore(this.name);
        if (store == null) {
            logger.finest("No data is found on this store to respond data request");
            return;
        }
        long version = store.getVersion();
        Set<RecordMigrationInfo> recordSet = this.getRecordSet(store);
        if (recordSet.isEmpty()) {
            logger.finest("No data is found on this store to respond data request");
            return;
        }
        SyncReplicatedMapDataOperation op = new SyncReplicatedMapDataOperation(this.name, recordSet, version);
        op.setPartitionId(this.getPartitionId());
        op.setValidateTarget(false);
        OperationService operationService = this.getNodeEngine().getOperationService();
        operationService.createInvocationBuilder("hz:impl:replicatedMapService", op, this.getCallerAddress()).setTryCount(3).invoke();
    }

    private Set<RecordMigrationInfo> getRecordSet(ReplicatedRecordStore store) {
        HashSet<RecordMigrationInfo> recordSet = new HashSet<RecordMigrationInfo>(store.size());
        Iterator<ReplicatedRecord> iterator = store.recordIterator();
        while (iterator.hasNext()) {
            ReplicatedRecord record = iterator.next();
            SerializationService serializationService = this.getNodeEngine().getSerializationService();
            Object dataKey = serializationService.toData(record.getKeyInternal());
            Object dataValue = serializationService.toData(record.getValueInternal());
            recordSet.add(new RecordMigrationInfo((Data)dataKey, (Data)dataValue, record.getTtlMillis()));
        }
        return recordSet;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
    }
}

