/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.replicatedmap.merge;

import com.att.aft.dme2.hazelcast.nio.ClassLoaderUtil;
import com.att.aft.dme2.hazelcast.replicatedmap.merge.HigherHitsMapMergePolicy;
import com.att.aft.dme2.hazelcast.replicatedmap.merge.LatestUpdateMapMergePolicy;
import com.att.aft.dme2.hazelcast.replicatedmap.merge.PassThroughMergePolicy;
import com.att.aft.dme2.hazelcast.replicatedmap.merge.PutIfAbsentMapMergePolicy;
import com.att.aft.dme2.hazelcast.replicatedmap.merge.ReplicatedMapMergePolicy;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.util.ConcurrencyUtil;
import com.att.aft.dme2.hazelcast.util.ConstructorFunction;
import com.att.aft.dme2.hazelcast.util.ExceptionUtil;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class MergePolicyProvider {
    private final ConcurrentMap<String, ReplicatedMapMergePolicy> mergePolicyMap;
    private final NodeEngine nodeEngine;
    private final ConstructorFunction<String, ReplicatedMapMergePolicy> policyConstructorFunction = new ConstructorFunction<String, ReplicatedMapMergePolicy>(){

        @Override
        public ReplicatedMapMergePolicy createNew(String className) {
            try {
                return (ReplicatedMapMergePolicy)ClassLoaderUtil.newInstance(MergePolicyProvider.this.nodeEngine.getConfigClassLoader(), className);
            }
            catch (Exception e) {
                MergePolicyProvider.this.nodeEngine.getLogger(this.getClass()).severe(e);
                throw ExceptionUtil.rethrow(e);
            }
        }
    };

    public MergePolicyProvider(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.mergePolicyMap = new ConcurrentHashMap<String, ReplicatedMapMergePolicy>();
        this.addOutOfBoxPolicies();
    }

    private void addOutOfBoxPolicies() {
        this.mergePolicyMap.put(PutIfAbsentMapMergePolicy.class.getName(), new PutIfAbsentMapMergePolicy());
        this.mergePolicyMap.put(HigherHitsMapMergePolicy.class.getName(), new HigherHitsMapMergePolicy());
        this.mergePolicyMap.put(PassThroughMergePolicy.class.getName(), new PassThroughMergePolicy());
        this.mergePolicyMap.put(LatestUpdateMapMergePolicy.class.getName(), new LatestUpdateMapMergePolicy());
    }

    public ReplicatedMapMergePolicy getMergePolicy(String className) {
        Preconditions.checkNotNull(className, "Class name is mandatory!");
        return ConcurrencyUtil.getOrPutIfAbsent(this.mergePolicyMap, className, this.policyConstructorFunction);
    }
}

