/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.ringbuffer.impl.operations;

import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.ringbuffer.impl.RingbufferContainer;
import com.att.aft.dme2.hazelcast.ringbuffer.impl.RingbufferDataSerializerHook;
import com.att.aft.dme2.hazelcast.ringbuffer.impl.RingbufferService;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;

public abstract class AbstractRingBufferOperation
extends AbstractOperation
implements IdentifiedDataSerializable,
PartitionAwareOperation {
    protected String name;
    private RingbufferContainer ringbuffer;

    public AbstractRingBufferOperation() {
    }

    public AbstractRingBufferOperation(String name) {
        this.name = name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:ringbufferService";
    }

    RingbufferContainer getRingBufferContainer() {
        if (this.ringbuffer != null) {
            return this.ringbuffer;
        }
        RingbufferService service = (RingbufferService)this.getService();
        RingbufferContainer ringbuffer = service.getContainer(this.name);
        ringbuffer.cleanup();
        this.ringbuffer = ringbuffer;
        return ringbuffer;
    }

    @Override
    public int getFactoryId() {
        return RingbufferDataSerializerHook.F_ID;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.name);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.name = in.readUTF();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", name=").append(this.name);
    }
}

