/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.ringbuffer.impl.operations;

import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.ringbuffer.OverflowPolicy;
import com.att.aft.dme2.hazelcast.ringbuffer.impl.RingbufferContainer;
import com.att.aft.dme2.hazelcast.ringbuffer.impl.operations.AbstractRingBufferOperation;
import com.att.aft.dme2.hazelcast.ringbuffer.impl.operations.AddBackupOperation;
import com.att.aft.dme2.hazelcast.spi.BackupAwareOperation;
import com.att.aft.dme2.hazelcast.spi.Notifier;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.WaitNotifyKey;
import java.io.IOException;

public class AddOperation
extends AbstractRingBufferOperation
implements Notifier,
BackupAwareOperation {
    private Data item;
    private long resultSequence;
    private OverflowPolicy overflowPolicy;

    public AddOperation() {
    }

    public AddOperation(String name, Data item, OverflowPolicy overflowPolicy) {
        super(name);
        this.item = item;
        this.overflowPolicy = overflowPolicy;
    }

    @Override
    public void run() throws Exception {
        RingbufferContainer ringbuffer = this.getRingBufferContainer();
        if (this.overflowPolicy == OverflowPolicy.FAIL && ringbuffer.remainingCapacity() < 1L) {
            this.resultSequence = -1L;
            return;
        }
        this.resultSequence = ringbuffer.add(this.item);
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        RingbufferContainer ringbuffer = this.getRingBufferContainer();
        return ringbuffer.getRingEmptyWaitNotifyKey();
    }

    @Override
    public boolean shouldNotify() {
        return this.resultSequence != -1L;
    }

    @Override
    public boolean shouldBackup() {
        return this.resultSequence != -1L;
    }

    @Override
    public int getSyncBackupCount() {
        RingbufferContainer ringbuffer = this.getRingBufferContainer();
        return ringbuffer.getConfig().getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        RingbufferContainer ringbuffer = this.getRingBufferContainer();
        return ringbuffer.getConfig().getAsyncBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new AddBackupOperation(this.name, this.item);
    }

    @Override
    public Long getResponse() {
        return this.resultSequence;
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeData(this.item);
        out.writeInt(this.overflowPolicy.getId());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.item = in.readData();
        this.overflowPolicy = OverflowPolicy.getById(in.readInt());
    }
}

