/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.ringbuffer.impl.operations;

import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.ringbuffer.impl.RingbufferContainer;
import com.att.aft.dme2.hazelcast.ringbuffer.impl.RingbufferDataSerializerHook;
import com.att.aft.dme2.hazelcast.ringbuffer.impl.RingbufferService;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ReplicationOperation
extends AbstractOperation
implements IdentifiedDataSerializable {
    private Map<String, RingbufferContainer> migrationData;

    public ReplicationOperation() {
    }

    public ReplicationOperation(Map<String, RingbufferContainer> migrationData, int partitionId, int replicaIndex) {
        this.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        this.migrationData = migrationData;
    }

    @Override
    public void run() {
        RingbufferService service = (RingbufferService)this.getService();
        for (Map.Entry<String, RingbufferContainer> entry : this.migrationData.entrySet()) {
            String name = entry.getKey();
            RingbufferContainer ringbuffer = entry.getValue();
            service.addRingbuffer(name, ringbuffer);
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:ringbufferService";
    }

    @Override
    public int getFactoryId() {
        return RingbufferDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 5;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.migrationData.size());
        for (Map.Entry<String, RingbufferContainer> entry : this.migrationData.entrySet()) {
            String ringbufferName = entry.getKey();
            out.writeUTF(ringbufferName);
            RingbufferContainer container = entry.getValue();
            container.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int mapSize = in.readInt();
        this.migrationData = new HashMap<String, RingbufferContainer>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            String name = in.readUTF();
            RingbufferContainer container = new RingbufferContainer(name);
            container.readData(in);
            this.migrationData.put(name, container);
        }
    }
}

