/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.spi;

import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.ObjectNamespace;
import java.io.IOException;

public final class DefaultObjectNamespace
implements ObjectNamespace {
    private String service;
    private String objectName;

    public DefaultObjectNamespace() {
    }

    public DefaultObjectNamespace(String serviceName, String objectName) {
        this.service = serviceName;
        this.objectName = objectName;
    }

    @Override
    public String getServiceName() {
        return this.service;
    }

    @Override
    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.service);
        out.writeObject(this.objectName);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.service = in.readUTF();
        this.objectName = (String)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultObjectNamespace that = (DefaultObjectNamespace)o;
        if (this.objectName != null ? !this.objectName.equals(that.objectName) : that.objectName != null) {
            return false;
        }
        return !(this.service != null ? !this.service.equals(that.service) : that.service != null);
    }

    public int hashCode() {
        int result = this.service != null ? this.service.hashCode() : 0;
        result = 31 * result + (this.objectName != null ? this.objectName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultObjectNamespace{service='" + this.service + '\'' + ", objectName=" + this.objectName + '}';
    }
}

